/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.webservices13.ejb.annotations.WSEjbWSRefRespBindAndAddressingCombinedTest;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.porting.TSURL;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxws.wsa.common.WsaSOAPUtils;
import com.sun.ts.tests.webservices13.ejb.annotations.WSEjbWSRefRespBindAndAddressingCombinedTest.Echo;
import com.sun.ts.tests.webservices13.ejb.annotations.WSEjbWSRefRespBindAndAddressingCombinedTest.EchoService;
import com.sun.ts.tests.webservices13.ejb.annotations.WSEjbWSRefRespBindAndAddressingCombinedTest.EjbClientIF;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import javax.ejb.EJB;
import javax.xml.ws.Holder;
import javax.xml.ws.RespectBinding;
import javax.xml.ws.WebServiceRef;
import javax.xml.ws.soap.Addressing;
import javax.xml.ws.soap.SOAPFaultException;

public class Client
extends EETest {
    private static final String PROTOCOL = "http";
    private static final String HOSTNAME = "localhost";
    private static final int PORTNUM = 8000;
    private static final String WEBSERVERHOSTPROP = "webServerHost";
    private static final String WEBSERVERPORTPROP = "webServerPort";
    private TSURL ctsurl = new TSURL();
    private Properties props = null;
    private String hostname = "localhost";
    private int portnum = 8000;
    private URL url = null;
    private URLConnection urlConn = null;
    private String SERVLET = "/WSEjbWSRefRespBindAndAddressingCombinedTestClnt_web/ServletTest";
    @Addressing
    @RespectBinding(enabled=true)
    @WebServiceRef(name="service/wsejbwsrefrespbindandaddrcombtestport1", type=Echo.class, value=EchoService.class)
    static Echo port1 = null;
    @Addressing(enabled=true, required=true)
    @RespectBinding(enabled=true)
    @WebServiceRef(name="service/wsejbwsrefrespbindandaddrcombtestport2", type=Echo.class, value=EchoService.class)
    static Echo port2 = null;
    @Addressing(enabled=false)
    @RespectBinding(enabled=true)
    @WebServiceRef(name="service/wsejbwsrefrespbindandaddrcombtestport3", type=Echo.class, value=EchoService.class)
    static Echo port3 = null;
    @WebServiceRef(name="service/wsejbwsrefrespbindandaddrcombtestservice")
    static EchoService service = null;
    @EJB(name="ejb/WSEjbWSRefRespBindAndAddressingCombinedTestClntBean")
    static EjbClientIF ejbclient;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.props = p;
        boolean pass = true;
        try {
            this.hostname = p.getProperty(WEBSERVERHOSTPROP);
            if (this.hostname == null) {
                pass = false;
            } else if (this.hostname.equals("")) {
                pass = false;
            }
            try {
                this.portnum = Integer.parseInt(p.getProperty(WEBSERVERPORTPROP));
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)("Appclient DEBUG: ejbclient=" + ejbclient));
            TestUtil.logMsg((String)("Appclient DEBUG: service=" + (Object)((Object)service)));
            TestUtil.logMsg((String)("Appclient DEBUG: port1=" + port1));
            TestUtil.logMsg((String)("Appclient DEBUG: port2=" + port2));
            TestUtil.logMsg((String)("Appclient DEBUG: port3=" + port3));
        }
        catch (Exception e) {
            throw new EETest.Fault("setup failed:", e);
        }
        if (service == null || port1 == null || port2 == null || port3 == null || ejbclient == null) {
            throw new EETest.Fault("setup failed: injection failure");
        }
        if (!pass) {
            TestUtil.logErr((String)"Please specify host & port of web server in config properties: webServerHost, webServerPort");
            throw new EETest.Fault("setup failed:");
        }
        ejbclient.init(p);
        TestUtil.logMsg((String)"setup ok");
    }

    public void cleanup() throws EETest.Fault {
        TestUtil.logMsg((String)"cleanup ok");
    }

    public void VerifyAddrHeadersExistForEnabledRequiredPort() throws EETest.Fault {
        Object testName;
        boolean pass = true;
        TestUtil.logMsg((String)"VerifyAddrHeadersExistForEnabledRequiredPort");
        try {
            TestUtil.logMsg((String)"-------------------------------");
            TestUtil.logMsg((String)"Test appclient invocation .....");
            TestUtil.logMsg((String)"-------------------------------");
            TestUtil.logMsg((String)"AppClient invoking EchoService echo() method");
            TestUtil.logMsg((String)"Addressing headers MUST be present on the SOAPRequest");
            TestUtil.logMsg((String)"VerifyAddrHeadersExistForEnabledRequiredPort");
            testName = new Holder((Object)"VerifyAddrHeadersExistForEnabledRequiredPort");
            port1.echo("Echo from AppClient on port1", (Holder<String>)testName);
            TestUtil.logMsg((String)"Addressing Headers Exist (Expected)");
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Addressing Headers DO NOT Exist (Unexpected)");
            pass = false;
        }
        try {
            TestUtil.logMsg((String)"-----------------------------------");
            TestUtil.logMsg((String)"Test servletclient invocation .....");
            TestUtil.logMsg((String)"-----------------------------------");
            this.url = this.ctsurl.getURL(PROTOCOL, this.hostname, this.portnum, this.SERVLET);
            TestUtil.logMsg((String)("Servlet URL: " + this.url));
            this.props.setProperty("TEST", "VerifyAddrHeadersExistForEnabledRequiredPort");
            this.urlConn = TestUtil.sendPostData((Properties)this.props, (URL)this.url);
            Properties p = TestUtil.getResponseProperties((URLConnection)this.urlConn);
            String passStr = p.getProperty("TESTRESULT");
            if (passStr.equals("fail")) {
                pass = false;
                TestUtil.logErr((String)"Addressing Headers DO NOT Exist (Unexpected)");
            } else {
                TestUtil.logMsg((String)"Addressing Headers Exist (Expected)");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Addressing Headers DO NOT Exist (Unexpected)");
            pass = false;
        }
        try {
            TestUtil.logMsg((String)"-------------------------------");
            TestUtil.logMsg((String)"Test ejbclient invocation .....");
            TestUtil.logMsg((String)"-------------------------------");
            testName = "VerifyAddrHeadersExistForEnabledRequiredPort";
            boolean passEjb = ejbclient.echo("Echo from EjbClient on port1", (String)testName);
            if (!passEjb) {
                TestUtil.logErr((String)"Addressing Headers DO NOT Exist (Unexpected)");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Addressing Headers Exist (Expected)");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Addressing Headers DO NOT Exist (Unexpected)");
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("VerifyAddrHeadersExistForEnabledRequiredPort failed");
        }
    }

    public void VerifyFaultConditionOnPort() throws EETest.Fault {
        Object testName;
        boolean pass = true;
        TestUtil.logMsg((String)"VerifyFaultConditionOnPort");
        try {
            TestUtil.logMsg((String)"-------------------------------");
            TestUtil.logMsg((String)"Test appclient invocation .....");
            TestUtil.logMsg((String)"-------------------------------");
            TestUtil.logMsg((String)"AppClient invoking EchoService echo() method");
            TestUtil.logMsg((String)"Addressing headers MUST NOT be present on the SOAPRequest");
            TestUtil.logMsg((String)"VerifyFaultConditionOnPort");
            testName = new Holder((Object)"VerifyFaultConditionOnPort");
            port3.echo("Echo from AppClient on port3", (Holder<String>)testName);
            TestUtil.logErr((String)"SOAPFaultException was not thrown back");
            pass = false;
        }
        catch (SOAPFaultException sfe) {
            TestUtil.logMsg((String)("Caught expected SOAPFaultException: " + sfe.getMessage()));
            try {
                TestUtil.logMsg((String)("FaultCode=" + WsaSOAPUtils.getFaultCode(sfe)));
                TestUtil.logMsg((String)("FaultString=" + WsaSOAPUtils.getFaultString(sfe)));
                if (WsaSOAPUtils.isMessageAddressingHeaderRequiredFaultCode(sfe)) {
                    TestUtil.logMsg((String)"SOAPFault contains expected faultcode MessageAddressingHeaderRequired");
                } else {
                    String faultcode = WsaSOAPUtils.getFaultCode(sfe);
                    TestUtil.logErr((String)("SOAPFault contains unexpected faultcode got: " + faultcode + ", expected: MessageAddressingHeaderRequired"));
                    pass = false;
                }
                if (WsaSOAPUtils.getFaultString(sfe) == null) {
                    TestUtil.logErr((String)"The faultstring element MUST EXIST for SOAP 1.1 Faults");
                    pass = false;
                }
                if (WsaSOAPUtils.getFaultDetail(sfe) != null) {
                    TestUtil.logErr((String)"The faultdetail element MUST NOT EXIST for SOAP 1.1 Faults related to header entries");
                    pass = false;
                }
            }
            catch (Exception e2) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e2.getMessage()));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught Exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        try {
            TestUtil.logMsg((String)"-----------------------------------");
            TestUtil.logMsg((String)"Test servletclient invocation .....");
            TestUtil.logMsg((String)"-----------------------------------");
            this.url = this.ctsurl.getURL(PROTOCOL, this.hostname, this.portnum, this.SERVLET);
            TestUtil.logMsg((String)("Servlet URL: " + this.url));
            this.props.setProperty("TEST", "VerifyFaultConditionOnPort");
            this.urlConn = TestUtil.sendPostData((Properties)this.props, (URL)this.url);
            Properties p = TestUtil.getResponseProperties((URLConnection)this.urlConn);
            String passStr = p.getProperty("TESTRESULT");
            if (passStr.equals("fail")) {
                pass = false;
                TestUtil.logErr((String)"VerifyFaultCondition (Unexpected)");
            } else {
                TestUtil.logMsg((String)"VerifyFaultCondition (Expected)");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught Exception: " + e.getMessage()));
            pass = false;
        }
        try {
            TestUtil.logMsg((String)"-------------------------------");
            TestUtil.logMsg((String)"Test ejbclient invocation .....");
            TestUtil.logMsg((String)"-------------------------------");
            testName = "VerifyFaultConditionOnPort";
            boolean passEjb = ejbclient.echo("Echo from EjbClient on port3", (String)testName);
            if (!passEjb) {
                TestUtil.logErr((String)"VerifyFaultCondition (Unexpected)");
                pass = false;
            } else {
                TestUtil.logMsg((String)"VerifyFaultCondition (Expected)");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught Exception: " + e.getMessage()));
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("VerifyFaultConditionOnPort failed");
        }
    }
}

