/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.serializer;

import javax.json.stream.JsonGenerator;
import org.eclipse.yasson.internal.model.customization.Customization;
import org.eclipse.yasson.internal.serializer.AbstractNumberSerializer;
import org.eclipse.yasson.internal.serializer.BigNumberUtil;

public class LongTypeSerializer
extends AbstractNumberSerializer<Long> {
    public LongTypeSerializer(Customization customization) {
        super(customization);
    }

    @Override
    protected void serializeNonFormatted(Long obj, JsonGenerator generator, String key) {
        if (BigNumberUtil.isIEEE754(obj)) {
            generator.write(key, obj.longValue());
        } else {
            generator.write(key, obj.toString());
        }
    }

    @Override
    protected void serializeNonFormatted(Long obj, JsonGenerator generator) {
        if (BigNumberUtil.isIEEE754(obj)) {
            generator.write(obj.longValue());
        } else {
            generator.write(obj.toString());
        }
    }
}

