/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.generator;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.glassfish.admin.rest.generator.ClassWriter;
import org.glassfish.admin.rest.generator.CollectionLeafMetaData;
import org.glassfish.admin.rest.generator.CommandResourceMetaData;
import org.glassfish.admin.rest.generator.GeneratorException;
import org.glassfish.admin.rest.generator.ResourcesGenerator;
import org.glassfish.admin.rest.utils.ResourceUtil;
import org.glassfish.config.support.Singleton;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.config.ConfigModel;
import org.jvnet.hk2.config.DomDocument;

public abstract class ResourcesGeneratorBase
implements ResourcesGenerator {
    private static Set<String> alreadyGenerated = new HashSet<String>();
    ServiceLocator habitat;
    private static final Map<String, String> configBeanToDELETECommand = Collections.unmodifiableMap(new HashMap<String, String>(){
        {
            this.put("AdminObjectResource", "delete-admin-object");
            this.put("AuditModule", "delete-audit-module");
            this.put("AuthRealm", "delete-auth-realm");
            this.put("ApplicationRef", "delete-application-ref");
            this.put("Cluster", "delete-cluster");
            this.put("ConnectorConnectionPool", "delete-connector-connection-pool");
            this.put("Config", "delete-config");
            this.put("ConnectorConnectionPool", "delete-connector-connection-pool");
            this.put("ConnectorResource", "delete-connector-resource");
            this.put("CustomResource", "delete-custom-resource");
            this.put("ExternalJndiResource", "delete-jndi-resource");
            this.put("HttpListener", "delete-http-listener");
            this.put("Http", "delete-http");
            this.put("IiopListener", "delete-iiop-listener");
            this.put("JdbcResource", "delete-jdbc-resource");
            this.put("JaccProvider", "delete-jacc-provider");
            this.put("LbConfig", "delete-http-lb-config");
            this.put("LoadBalancer", "delete-http-lb");
            this.put("NetworkListener", "delete-network-listener");
            this.put("Profiler", "delete-profiler");
            this.put("Protocol", "delete-protocol");
            this.put("ProtocolFilter", "delete-protocol-filter");
            this.put("ProtocolFinder", "delete-protocol-finder");
            this.put("ProviderConfig", "delete-message-security-provider");
            this.put("ResourceAdapterConfig", "delete-resource-adapter-config");
            this.put("SecurityMap", "delete-connector-security-map");
            this.put("Ssl", "delete-ssl");
            this.put("Transport", "delete-transport");
            this.put("ThreadPool", "delete-threadpool");
            this.put("VirtualServer", "delete-virtual-server");
            this.put("WorkSecurityMap", "delete-connector-work-security-map");
        }
    });
    public static final Map<String, String> configBeanToPOSTCommand = Collections.unmodifiableMap(new HashMap<String, String>(){
        {
            this.put("Application", "redeploy");
            this.put("JavaConfig", "create-profiler");
            this.put("ListAdminObjectResource", "create-admin-object");
            this.put("ListApplication", "deploy");
            this.put("ListApplicationRef", "create-application-ref");
            this.put("ListAuditModule", "create-audit-module");
            this.put("ListAuthRealm", "create-auth-realm");
            this.put("ListCluster", "create-cluster");
            this.put("ListConfig", "_create-config");
            this.put("ListConnectorConnectionPool", "create-connector-connection-pool");
            this.put("ListConnectorResource", "create-connector-resource");
            this.put("ListCustomResource", "create-custom-resource");
            this.put("ListExternalJndiResource", "create-jndi-resource");
            this.put("ListHttpListener", "create-http-listener");
            this.put("ListIiopListener", "create-iiop-listener");
            this.put("ListJaccProvider", "create-jacc-provider");
            this.put("ListJdbcConnectionPool", "create-jdbc-connection-pool");
            this.put("ListJdbcResource", "create-jdbc-resource");
            this.put("ListJmsHost", "create-jms-host");
            this.put("ListLbConfig", "create-http-lb-config");
            this.put("ListLoadBalancer", "create-http-lb");
            this.put("ListMailResource", "create-javamail-resource");
            this.put("ListMessageSecurityConfig", "create-message-security-provider");
            this.put("ListNetworkListener", "create-network-listener");
            this.put("ListProtocol", "create-protocol");
            this.put("ListResourceAdapterConfig", "create-resource-adapter-config");
            this.put("ListResourceRef", "create-resource-ref");
            this.put("ListSystemProperty", "create-system-properties");
            this.put("ListThreadPool", "create-threadpool");
            this.put("ListTransport", "create-transport");
            this.put("ListVirtualServer", "create-virtual-server");
            this.put("ListWorkSecurityMap", "create-connector-work-security-map");
            this.put("ProtocolFilter", "create-protocol-filter");
            this.put("ProtocolFinder", "create-protocol-finder");
            this.put("ListSecurityMap", "create-connector-security-map");
        }
    });
    public static final Map<String, CollectionLeafMetaData> configBeanToCollectionLeafMetaData = new HashMap<String, CollectionLeafMetaData>(){
        {
            this.put("JvmOptions", new CollectionLeafMetaData("create-jvm-options", "delete-jvm-options", "JvmOption"));
        }
    };

    public ResourcesGeneratorBase(ServiceLocator habitat) {
        this.habitat = habitat;
    }

    @Override
    public void generateSingle(ConfigModel model, DomDocument domDocument) {
        ClassWriter classWriter;
        this.configModelVisited(model);
        String serverConfigName = ResourceUtil.getUnqualifiedTypeName(model.targetTypeName);
        String beanName = ResourcesGeneratorBase.getBeanName(serverConfigName);
        String className = this.getClassName(beanName);
        if (this.alreadyGenerated(className)) {
            return;
        }
        String baseClassName = "TemplateRestResource";
        String resourcePath = null;
        if (beanName.equals("Domain")) {
            baseClassName = "org.glassfish.admin.rest.resources.GlassFishDomainResource";
            resourcePath = "domain";
        }
        if ((classWriter = this.getClassWriter(className, baseClassName, resourcePath)) != null) {
            this.generateCommandResources(beanName, classWriter);
            this.generateGetDeleteCommandMethod(beanName, classWriter);
            this.generateCustomResourceMapping(beanName, classWriter);
            for (String elementName : model.getElementNames()) {
                ConfigModel.Property childElement = model.getElement(elementName);
                if (elementName.equals("*")) {
                    ConfigModel.Node node = (ConfigModel.Node)childElement;
                    ConfigModel childModel = node.getModel();
                    List<ConfigModel> subChildConfigModels = ResourceUtil.getRealChildConfigModels(childModel, domDocument);
                    for (ConfigModel subChildConfigModel : subChildConfigModels) {
                        if (ResourceUtil.isOnlyATag(childModel) || ResourceUtil.isOnlyATag(subChildConfigModel) || subChildConfigModel.getAttributeNames().isEmpty() || this.hasSingletonAnnotation(subChildConfigModel)) {
                            String childResourceClassName = this.getClassName(ResourceUtil.getUnqualifiedTypeName(subChildConfigModel.targetTypeName));
                            String childPath = subChildConfigModel.getTagName();
                            classWriter.createGetChildResource(childPath, childResourceClassName);
                            this.generateSingle(subChildConfigModel, domDocument);
                            continue;
                        }
                        this.processNonLeafChildConfigModel(subChildConfigModel, childElement, domDocument, classWriter);
                    }
                    continue;
                }
                if (childElement.isLeaf()) {
                    String childResourceClassName;
                    String childResourceBeanName;
                    if (childElement.isCollection()) {
                        childResourceBeanName = ResourcesGeneratorBase.getBeanName(elementName);
                        childResourceClassName = this.getClassName(childResourceBeanName);
                        classWriter.createGetChildResource(elementName, childResourceClassName);
                        this.generateCollectionLeafResource(childResourceBeanName);
                        continue;
                    }
                    childResourceBeanName = ResourcesGeneratorBase.getBeanName(elementName);
                    childResourceClassName = this.getClassName(childResourceBeanName);
                    classWriter.createGetChildResource(elementName, childResourceClassName);
                    this.generateLeafResource(childResourceBeanName);
                    continue;
                }
                this.processNonLeafChildElement(elementName, childElement, domDocument, classWriter);
            }
            classWriter.done();
        }
    }

    public void generateList(ConfigModel model, DomDocument domDocument) {
        this.configModelVisited(model);
        String serverConfigName = ResourceUtil.getUnqualifiedTypeName(model.targetTypeName);
        String beanName = ResourcesGeneratorBase.getBeanName(serverConfigName);
        String className = "List" + this.getClassName(beanName);
        if (this.alreadyGenerated(className)) {
            return;
        }
        ClassWriter classWriter = this.getClassWriter(className, "TemplateListOfResource", null);
        if (classWriter != null) {
            String keyAttributeName = this.getKeyAttributeName(model);
            String childResourceClassName = this.getClassName(beanName);
            classWriter.createGetChildResourceForListResources(keyAttributeName, childResourceClassName);
            this.generateCommandResources("List" + beanName, classWriter);
            this.generateGetPostCommandMethod("List" + beanName, classWriter);
            classWriter.done();
            this.generateSingle(model, domDocument);
        }
    }

    public void configModelVisited(ConfigModel model) {
    }

    private void generateCollectionLeafResource(String beanName) {
        String className = this.getClassName(beanName);
        if (this.alreadyGenerated(className)) {
            return;
        }
        ClassWriter classWriter = this.getClassWriter(className, "CollectionLeafResource", null);
        if (classWriter != null) {
            CollectionLeafMetaData metaData = configBeanToCollectionLeafMetaData.get(beanName);
            if (metaData != null) {
                if (metaData.postCommandName != null && ResourceUtil.commandIsPresent(this.habitat, metaData.postCommandName)) {
                    classWriter.createGetPostCommandForCollectionLeafResource(metaData.postCommandName);
                }
                if (metaData.deleteCommandName != null && ResourceUtil.commandIsPresent(this.habitat, metaData.deleteCommandName)) {
                    classWriter.createGetDeleteCommandForCollectionLeafResource(metaData.deleteCommandName);
                }
                classWriter.createGetDisplayNameForCollectionLeafResource(metaData.displayName);
            }
            classWriter.done();
        }
    }

    private void generateLeafResource(String beanName) {
        String className = this.getClassName(beanName);
        if (this.alreadyGenerated(className)) {
            return;
        }
        ClassWriter classWriter = this.getClassWriter(className, "LeafResource", null);
        if (classWriter != null) {
            classWriter.done();
        }
    }

    private void processNonLeafChildElement(String elementName, ConfigModel.Property childElement, DomDocument domDocument, ClassWriter classWriter) {
        ConfigModel.Node node = (ConfigModel.Node)childElement;
        ConfigModel childModel = node.getModel();
        String beanName = ResourceUtil.getUnqualifiedTypeName(childModel.targetTypeName);
        if (beanName.equals("Property")) {
            classWriter.createGetChildResource("property", "PropertiesBagResource");
        } else {
            String childResourceClassName = this.getClassName(beanName);
            if (childElement.isCollection()) {
                childResourceClassName = "List" + childResourceClassName;
            }
            classWriter.createGetChildResource(elementName, childResourceClassName);
        }
        if (childElement.isCollection()) {
            this.generateList(childModel, domDocument);
        } else {
            this.generateSingle(childModel, domDocument);
        }
    }

    private void processNonLeafChildConfigModel(ConfigModel childConfigModel, ConfigModel.Property childElement, DomDocument domDocument, ClassWriter classWriter) {
        String childResourceClassName = this.getClassName("List" + ResourceUtil.getUnqualifiedTypeName(childConfigModel.targetTypeName));
        String childPath = childConfigModel.getTagName();
        classWriter.createGetChildResource(childPath, childResourceClassName);
        if (childElement.isCollection()) {
            this.generateList(childConfigModel, domDocument);
        }
    }

    private void generateGetDeleteCommandMethod(String beanName, ClassWriter classWriter) {
        String commandName = configBeanToDELETECommand.get(beanName);
        if (commandName != null && ResourceUtil.commandIsPresent(this.habitat, commandName)) {
            classWriter.createGetDeleteCommand(commandName);
        }
    }

    private void generateCustomResourceMapping(String beanName, ClassWriter classWriter) {
        for (CommandResourceMetaData cmd : CommandResourceMetaData.getCustomResourceMapping(beanName)) {
            classWriter.createCustomResourceMapping(cmd.customClassName, cmd.resourcePath);
        }
    }

    void generateGetPostCommandMethod(String resourceName, ClassWriter classWriter) {
        String commandName = configBeanToPOSTCommand.get(resourceName);
        if (commandName != null && ResourceUtil.commandIsPresent(this.habitat, commandName)) {
            classWriter.createGetPostCommand(commandName);
        }
    }

    private void generateCommandResources(String parentBeanName, ClassWriter parentWriter) {
        List<CommandResourceMetaData> commandMetaData = CommandResourceMetaData.getMetaData(parentBeanName);
        if (commandMetaData.size() > 0) {
            for (CommandResourceMetaData metaData : commandMetaData) {
                if (!ResourceUtil.commandIsPresent(this.habitat, metaData.command)) continue;
                String commandResourceName = parentBeanName + ResourcesGeneratorBase.getBeanName(metaData.resourcePath);
                String commandResourceClassName = this.getClassName(commandResourceName);
                this.generateCommandResourceClass(parentBeanName, metaData);
                parentWriter.createGetCommandResource(commandResourceClassName, metaData.resourcePath);
            }
            parentWriter.createGetCommandResourcePaths(commandMetaData);
        }
    }

    private void generateCommandResourceClass(String parentBeanName, CommandResourceMetaData metaData) {
        String baseClassName;
        String commandResourceClassName = this.getClassName(parentBeanName + ResourcesGeneratorBase.getBeanName(metaData.resourcePath));
        if (this.alreadyGenerated(commandResourceClassName)) {
            return;
        }
        String commandName = metaData.command;
        String commandDisplayName = metaData.resourcePath;
        String httpMethod = metaData.httpMethod;
        String commandAction = metaData.displayName;
        if ("GET".equals(httpMethod)) {
            baseClassName = "org.glassfish.admin.rest.resources.TemplateCommandGetResource";
        } else if ("DELETE".equals(httpMethod)) {
            baseClassName = "org.glassfish.admin.rest.resources.TemplateCommandDeleteResource";
        } else if ("POST".equals(httpMethod)) {
            baseClassName = "org.glassfish.admin.rest.resources.TemplateCommandPostResource";
        } else {
            throw new GeneratorException("Invalid httpMethod specified: " + httpMethod);
        }
        ClassWriter classWriter = this.getClassWriter(commandResourceClassName, baseClassName, null);
        if (classWriter != null) {
            boolean isLinkedToParent = false;
            if (metaData.commandParams != null) {
                for (CommandResourceMetaData.ParameterMetaData parameterMetaData : metaData.commandParams) {
                    if (!"$parent".equals(parameterMetaData.value)) continue;
                    isLinkedToParent = true;
                }
            }
            classWriter.createCommandResourceConstructor(commandResourceClassName, commandName, httpMethod, isLinkedToParent, metaData.commandParams, commandDisplayName, commandAction);
            classWriter.done();
        }
    }

    protected boolean alreadyGenerated(String className) {
        boolean retVal = true;
        if (!alreadyGenerated.contains(className)) {
            alreadyGenerated.add(className);
            retVal = false;
        }
        return retVal;
    }

    private String getClassName(String beanName) {
        return beanName + "Resource";
    }

    public static String getBeanName(String elementName) {
        StringBuilder ret = new StringBuilder();
        boolean nextisUpper = true;
        for (int i = 0; i < elementName.length(); ++i) {
            if (nextisUpper) {
                ret.append(elementName.substring(i, i + 1).toUpperCase(Locale.US));
                nextisUpper = false;
                continue;
            }
            if (elementName.charAt(i) == '-') {
                nextisUpper = true;
                continue;
            }
            if (elementName.charAt(i) == '/') {
                nextisUpper = true;
                continue;
            }
            nextisUpper = false;
            ret.append(elementName.substring(i, i + 1));
        }
        return ret.toString();
    }

    private String getKeyAttributeName(ConfigModel model) {
        String keyAttributeName = null;
        if (model.key == null) {
            for (String s : model.getAttributeNames()) {
                if (!s.equals("name")) continue;
                keyAttributeName = ResourcesGeneratorBase.getBeanName(s);
            }
            if (keyAttributeName == null) {
                Set attributeNames = model.getAttributeNames();
                keyAttributeName = !attributeNames.isEmpty() ? ResourcesGeneratorBase.getBeanName((String)attributeNames.iterator().next()) : "ThisIsAModelBug:NoKeyAttr";
            }
        } else {
            int keyLength = model.key.length();
            String key = model.key.substring(1, model.key.endsWith(">") ? keyLength - 1 : keyLength);
            keyAttributeName = ResourcesGeneratorBase.getBeanName(key);
        }
        return keyAttributeName;
    }

    private boolean hasSingletonAnnotation(ConfigModel model) {
        Class cbp = null;
        try {
            cbp = model.classLoaderHolder.loadClass(model.targetTypeName);
            if (cbp != null) {
                Singleton sing = cbp.getAnnotation(Singleton.class);
                return sing != null;
            }
        }
        catch (MultiException e) {
            e.printStackTrace();
        }
        return false;
    }
}

