/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.cms.impl.common;

import com.sun.enterprise.ee.cms.core.FailureNotificationActionFactory;
import com.sun.enterprise.ee.cms.core.FailureRecoveryActionFactory;
import com.sun.enterprise.ee.cms.core.FailureSuspectedActionFactory;
import com.sun.enterprise.ee.cms.core.GMSCacheable;
import com.sun.enterprise.ee.cms.core.GMSConstants;
import com.sun.enterprise.ee.cms.core.GMSException;
import com.sun.enterprise.ee.cms.core.GMSFactory;
import com.sun.enterprise.ee.cms.core.GroupHandle;
import com.sun.enterprise.ee.cms.core.GroupLeadershipNotificationActionFactory;
import com.sun.enterprise.ee.cms.core.GroupManagementService;
import com.sun.enterprise.ee.cms.core.JoinNotificationActionFactory;
import com.sun.enterprise.ee.cms.core.JoinedAndReadyNotificationActionFactory;
import com.sun.enterprise.ee.cms.core.MessageActionFactory;
import com.sun.enterprise.ee.cms.core.PlannedShutdownActionFactory;
import com.sun.enterprise.ee.cms.impl.base.GMSContextImpl;
import com.sun.enterprise.ee.cms.impl.common.GMSContext;
import com.sun.enterprise.ee.cms.impl.common.GMSContextFactory;
import com.sun.enterprise.ee.cms.impl.common.Router;
import com.sun.enterprise.ee.cms.logging.GMSLogDomain;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GroupManagementServiceImpl
implements GroupManagementService,
Runnable {
    private GMSContext ctx;
    private Router router;
    private String memberName = "";
    private AtomicBoolean initialized = new AtomicBoolean(false);
    private AtomicBoolean hasLeftGroup = new AtomicBoolean(false);
    private AtomicBoolean hasJoinedGroup = new AtomicBoolean(false);
    private static final Logger logger = GMSLogDomain.getLogger("ShoalLogger");
    private static final String MEMBER_DETAILS = "MEMBERDETAILS";

    public GroupManagementServiceImpl(String serverToken, String groupName, GroupManagementService.MemberType membertype, Properties properties) {
        this.initialize(serverToken, groupName, membertype, properties);
        this.memberName = serverToken;
    }

    public GroupManagementServiceImpl() {
    }

    public void initialize(String serverToken, String groupName, GroupManagementService.MemberType membertype, Properties properties) {
        if (this.initialized.compareAndSet(false, true)) {
            this.ctx = GMSContextFactory.produceGMSContext(serverToken, groupName, membertype, properties);
            this.router = this.ctx.getRouter();
            this.memberName = serverToken;
        }
    }

    @Override
    public void run() {
        this.startup();
    }

    private void startup() {
        try {
            logger.log(Level.INFO, "gms.joinMessage");
            this.join();
        }
        catch (GMSException e) {
            logger.log(Level.FINE, "gms.joinException", e);
        }
    }

    public void addActionFactory(FailureNotificationActionFactory failureNotificationActionFactory) {
        this.router.addDestination(failureNotificationActionFactory);
    }

    public void addActionFactory(String componentName, FailureRecoveryActionFactory failureRecoveryActionFactory) {
        this.router.addDestination(componentName, failureRecoveryActionFactory);
    }

    public void addActionFactory(JoinedAndReadyNotificationActionFactory joinedAndReadyNotificationActionFactory) {
        this.router.addDestination(joinedAndReadyNotificationActionFactory);
    }

    public void addActionFactory(JoinNotificationActionFactory joinNotificationActionFactory) {
        this.router.addDestination(joinNotificationActionFactory);
    }

    public void addActionFactory(PlannedShutdownActionFactory plannedShutdownActionFactory) {
        this.router.addDestination(plannedShutdownActionFactory);
    }

    public void addActionFactory(MessageActionFactory messageActionFactory, String componentName) {
        this.router.addDestination(messageActionFactory, componentName);
    }

    public void addActionFactory(FailureSuspectedActionFactory failureSuspectedActionFactory) {
        this.router.addDestination(failureSuspectedActionFactory);
    }

    public void addActionFactory(GroupLeadershipNotificationActionFactory groupLeadershipNotificationActionFactory) {
        this.router.addDestination(groupLeadershipNotificationActionFactory);
    }

    public void removeActionFactory(FailureNotificationActionFactory failureNotificationActionFactory) {
        this.router.removeDestination(failureNotificationActionFactory);
    }

    public void removeFailureRecoveryActionFactory(String componentName) {
        this.router.removeFailureRecoveryAFDestination(componentName);
    }

    public void removeFailureSuspectedActionFactory(FailureSuspectedActionFactory failureSuspectedActionFactory) {
        this.router.removeDestination(failureSuspectedActionFactory);
    }

    public void removeActionFactory(JoinNotificationActionFactory joinNotificationActionFactory) {
        this.router.removeDestination(joinNotificationActionFactory);
    }

    public void removeActionFactory(JoinedAndReadyNotificationActionFactory joinedAndReadyNotificationActionFactory) {
        this.router.removeDestination(joinedAndReadyNotificationActionFactory);
    }

    public void removeActionFactory(PlannedShutdownActionFactory plannedShutdownActionFactory) {
        this.router.removeDestination(plannedShutdownActionFactory);
    }

    public void removeMessageActionFactory(String componentName) {
        this.router.removeMessageAFDestination(componentName);
    }

    public void removeActionFactory(GroupLeadershipNotificationActionFactory groupLeadershipNotificationActionFactory) {
        this.router.removeDestination(groupLeadershipNotificationActionFactory);
    }

    public GroupHandle getGroupHandle() {
        return this.ctx.getGroupHandle();
    }

    public void shutdown(GMSConstants.shutdownType shutdownType2) {
        this.leave(shutdownType2);
    }

    public void updateMemberDetails(String memberToken, Serializable key, Serializable value) throws GMSException {
        if (this.isWatchdog()) {
            return;
        }
        this.ctx.getDistributedStateCache().addToCache(MEMBER_DETAILS, memberToken, key, value);
    }

    public Map<Serializable, Serializable> getMemberDetails(String memberToken) {
        if (this.isWatchdog()) {
            HashMap<Serializable, Serializable> retval = new HashMap<Serializable, Serializable>();
            return retval;
        }
        return this.ctx.getDistributedStateCache().getFromCacheForPattern(MEMBER_DETAILS, memberToken);
    }

    public Map<Serializable, Serializable> getAllMemberDetails(Serializable key) {
        HashMap<Serializable, Serializable> retval = new HashMap<Serializable, Serializable>();
        if (this.isWatchdog()) {
            return retval;
        }
        Map ret = this.ctx.getDistributedStateCache().getFromCache((Object)key);
        for (Map.Entry entry : ret.entrySet()) {
            GMSCacheable c = (GMSCacheable)entry.getKey();
            if (!c.getComponentName().equals(MEMBER_DETAILS)) continue;
            retval.put((Serializable)((Object)c.getMemberTokenId()), (Serializable)entry.getValue());
        }
        return retval;
    }

    public String getGroupName() {
        if (this.isWatchdog()) {
            return "";
        }
        return this.ctx.getGroupName();
    }

    public GroupManagementService.MemberType getMemberType() {
        return this.ctx.getMemberType();
    }

    public String getInstanceName() {
        return this.ctx.getServerIdentityToken();
    }

    public void setMemberDetails(String serverToken, Map<? extends Object, ? extends Object> keyValuePairs) throws GMSException {
        if (this.isWatchdog()) {
            return;
        }
        for (Map.Entry<? extends Object, ? extends Object> entry : keyValuePairs.entrySet()) {
            this.ctx.getDistributedStateCache().addToLocalCache(MEMBER_DETAILS, serverToken, (Serializable)entry.getKey(), (Serializable)entry.getValue());
        }
    }

    public void join() throws GMSException {
        if (this.hasJoinedGroup.compareAndSet(false, true)) {
            logger.log(Level.INFO, "gms.join", new Object[]{this.memberName, this.ctx.getGroupName()});
            this.ctx.join();
            this.hasLeftGroup.set(false);
        }
    }

    private void leave(GMSConstants.shutdownType shutdownType2) {
        if (this.hasLeftGroup.compareAndSet(false, true)) {
            try {
                logger.log(Level.INFO, "gms.leave", new Object[]{this.memberName, this.ctx.getGroupName()});
                this.ctx.leave(shutdownType2);
                this.removeAllActionFactories();
            }
            finally {
                this.hasJoinedGroup.set(false);
                GMSFactory.removeGMSModule((String)this.ctx.getGroupName());
                GMSContextFactory.removeGMSContext(this.ctx.getGroupName());
            }
        }
    }

    private void removeAllActionFactories() {
        this.router.undocketAllDestinations();
    }

    public void announceGroupShutdown(String groupName, GMSConstants.shutdownState shutdownState2) {
        GMSContext gctx = GMSContextFactory.getGMSContext(groupName);
        logger.log(Level.INFO, "gms.group.shutdown", new Object[]{groupName, shutdownState2});
        gctx.announceGroupShutdown(groupName, shutdownState2);
    }

    public void announceGroupStartup(String groupName, GMSConstants.groupStartupState startupState, List<String> memberTokens) {
        GMSContext gctx = GMSContextFactory.getGMSContext(groupName);
        StringBuffer sb = new StringBuffer(120);
        if (memberTokens != null) {
            for (String memberToken : memberTokens) {
                sb.append(memberToken).append(",");
            }
        }
        logger.log(Level.INFO, "gms.group.startup", new Object[]{startupState.toString(), groupName, sb.toString()});
        gctx.announceGroupStartup(groupName, startupState, memberTokens);
    }

    public void reportJoinedAndReadyState(String groupName) {
        GMSContext gctx = GMSContextFactory.getGMSContext(groupName);
        if (gctx != null) {
            logger.log(Level.INFO, "gms.ready", new Object[]{groupName});
            gctx.getGroupCommunicationProvider().reportJoinedAndReadyState();
        } else {
            this.reportJoinedAndReadyState();
        }
    }

    public void reportJoinedAndReadyState() {
        if (this.ctx == null) {
            throw new IllegalStateException("GMSContext for group name " + this.getGroupName() + " unexpectedly null");
        }
        logger.log(Level.INFO, "gms.ready", new Object[]{this.getGroupName()});
        this.ctx.getGroupCommunicationProvider().reportJoinedAndReadyState();
    }

    public boolean isGroupBeingShutdown(String groupName) {
        return this.ctx.isGroupBeingShutdown(groupName);
    }

    public boolean isGroupBeingShutdown() {
        return this.ctx.isGroupBeingShutdown(this.getGroupName());
    }

    public void announceWatchdogObservedFailure(String serverToken) throws GMSException {
        if (!this.isWatchdog()) {
            throw new GMSException("illegal state: announceWatchdogObservedFailure operation is only valid for a WATCHDOG member.");
        }
        GroupHandle gh = this.ctx.getGroupHandle();
        this.ctx.getGroupCommunicationProvider().announceWatchdogObservedFailure(serverToken);
    }

    private boolean isWatchdog() {
        return this.ctx.getMemberType() == GroupManagementService.MemberType.WATCHDOG;
    }

    public int outstandingNotifications() {
        return ((GMSContextImpl)this.ctx).outstandingNotifications();
    }
}

