/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.concurrent.runtime.deployer;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.BindableResource;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.Resources;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import org.glassfish.api.logging.LogHelper;
import org.glassfish.concurrent.LogFacade;
import org.glassfish.concurrent.config.ContextService;
import org.glassfish.concurrent.runtime.ConcurrentRuntime;
import org.glassfish.concurrent.runtime.deployer.ContextServiceConfig;
import org.glassfish.resourcebase.resources.api.GenericResourceInfo;
import org.glassfish.resourcebase.resources.api.ResourceConflictException;
import org.glassfish.resourcebase.resources.api.ResourceDeployer;
import org.glassfish.resourcebase.resources.api.ResourceDeployerInfo;
import org.glassfish.resourcebase.resources.api.ResourceInfo;
import org.glassfish.resourcebase.resources.naming.ResourceNamingService;
import org.glassfish.resourcebase.resources.util.ResourceUtil;
import org.glassfish.resources.naming.SerializableObjectRefAddr;
import org.jvnet.hk2.annotations.Service;

@Service
@ResourceDeployerInfo(value=ContextService.class)
@Singleton
public class ContextServiceDeployer
implements ResourceDeployer {
    @Inject
    private ResourceNamingService namingService;
    @Inject
    ConcurrentRuntime concurrentRuntime;
    private static Logger _logger = LogFacade.getLogger();

    public void deployResource(Object resource, String applicationName, String moduleName) throws Exception {
        ContextService contextServiceRes = (ContextService)resource;
        if (contextServiceRes == null) {
            _logger.log(Level.WARNING, "AS-CONCURRENT-00004", "ContextService");
            return;
        }
        String jndiName = contextServiceRes.getJndiName();
        String contextInfo = contextServiceRes.getContextInfo();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "ContextServiceDeployer.deployResource() : jndi-name [" + jndiName + "],  context-info [" + contextInfo + "]");
        }
        ResourceInfo resourceInfo = new ResourceInfo(contextServiceRes.getJndiName(), applicationName, moduleName);
        ContextServiceConfig config = new ContextServiceConfig(contextServiceRes);
        Reference ref = new Reference(javax.enterprise.concurrent.ContextService.class.getName(), "org.glassfish.concurrent.runtime.deployer.ConcurrentObjectFactory", null);
        SerializableObjectRefAddr addr = new SerializableObjectRefAddr(ContextServiceConfig.class.getName(), (Object)config);
        ref.add((RefAddr)addr);
        SerializableObjectRefAddr resAddr = new SerializableObjectRefAddr(ResourceInfo.class.getName(), (Object)resourceInfo);
        ref.add((RefAddr)resAddr);
        try {
            this.namingService.publishObject(resourceInfo, (Object)ref, true);
        }
        catch (NamingException ex) {
            LogHelper.log((Logger)_logger, (Level)Level.SEVERE, (String)"AS-CONCURRENT-00003", (Throwable)ex, (Object[])new Object[]{"ContextService", jndiName});
        }
    }

    public void deployResource(Object resource) throws Exception {
        ContextService contextServiceResource = (ContextService)resource;
        ResourceInfo resourceInfo = ResourceUtil.getResourceInfo((BindableResource)contextServiceResource);
        this.deployResource(resource, resourceInfo.getApplicationName(), resourceInfo.getModuleName());
    }

    public void undeployResource(Object resource) throws Exception {
        ContextService contextServiceResource = (ContextService)resource;
        ResourceInfo resourceInfo = ResourceUtil.getResourceInfo((BindableResource)contextServiceResource);
        this.undeployResource(resource, resourceInfo.getApplicationName(), resourceInfo.getModuleName());
    }

    public void undeployResource(Object resource, String applicationName, String moduleName) throws Exception {
        ContextService contextServiceRes = (ContextService)resource;
        ResourceInfo resourceInfo = new ResourceInfo(contextServiceRes.getJndiName(), applicationName, moduleName);
        this.namingService.unpublishObject((GenericResourceInfo)resourceInfo, contextServiceRes.getJndiName());
        this.concurrentRuntime.shutdownContextService(contextServiceRes.getJndiName());
    }

    public void redeployResource(Object resource) throws Exception {
        this.undeployResource(resource);
        this.deployResource(resource);
    }

    public void enableResource(Object resource) throws Exception {
        this.deployResource(resource);
    }

    public void disableResource(Object resource) throws Exception {
        this.undeployResource(resource);
    }

    public boolean handles(Object resource) {
        return resource instanceof ContextService;
    }

    public boolean supportsDynamicReconfiguration() {
        return false;
    }

    public Class[] getProxyClassesForDynamicReconfiguration() {
        return new Class[0];
    }

    public boolean canDeploy(boolean postApplicationDeployment, Collection<Resource> allResources, Resource resource) {
        return this.handles(resource) && !postApplicationDeployment;
    }

    public void validatePreservedResource(Application oldApp, Application newApp, Resource resource, Resources allResources) throws ResourceConflictException {
    }
}

