/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.cm.impl;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.felix.cm.NotCachablePersistenceManager;
import org.apache.felix.cm.PersistenceManager;
import org.apache.felix.cm.impl.CaseInsensitiveDictionary;
import org.apache.felix.cm.impl.Factory;
import org.apache.felix.cm.impl.SimpleFilter;

class CachingPersistenceManagerProxy
implements PersistenceManager {
    private final PersistenceManager pm;
    private final Hashtable<String, CaseInsensitiveDictionary> cache;
    private final ReadWriteLock globalLock = new ReentrantReadWriteLock();
    private boolean fullyLoaded;

    public CachingPersistenceManagerProxy(PersistenceManager pm) {
        this.pm = pm;
        this.cache = new Hashtable();
    }

    public boolean isNotCachablePersistenceManager() {
        return this.pm instanceof NotCachablePersistenceManager;
    }

    public PersistenceManager getDelegatee() {
        return this.pm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(String pid) throws IOException {
        Lock lock = this.globalLock.writeLock();
        try {
            lock.lock();
            this.cache.remove(pid);
            this.pm.delete(pid);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(String pid) {
        Lock lock = this.globalLock.readLock();
        try {
            lock.lock();
            boolean bl = this.cache.containsKey(pid) || !this.fullyLoaded && this.pm.exists(pid);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public Enumeration getDictionaries() throws IOException {
        return this.getDictionaries(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getDictionaries(SimpleFilter filter) throws IOException {
        Lock lock = this.globalLock.readLock();
        try {
            lock.lock();
            boolean fullyLoaded = this.fullyLoaded;
            if (this.pm instanceof NotCachablePersistenceManager) {
                fullyLoaded = false;
            }
            if (!fullyLoaded) {
                lock.unlock();
                lock = this.globalLock.writeLock();
                lock.lock();
                if (!fullyLoaded) {
                    Enumeration fromPm = this.pm.getDictionaries();
                    while (fromPm.hasMoreElements()) {
                        Dictionary next = (Dictionary)fromPm.nextElement();
                        String string = (String)next.get("service.pid");
                        if (string != null) {
                            this.cache.put(string, this.copy(next));
                            continue;
                        }
                        String string2 = (String)next.get("factory.pid");
                        if (string2 == null) continue;
                        String string3 = Factory.factoryPidToIdentifier(string2);
                        this.cache.put(string3, this.copy(next));
                    }
                    this.fullyLoaded = true;
                }
            }
            Vector<CaseInsensitiveDictionary> configs = new Vector<CaseInsensitiveDictionary>();
            for (Dictionary dictionary : this.cache.values()) {
                if (dictionary.get("service.pid") == null || filter != null && !filter.matches(dictionary)) continue;
                configs.add(this.copy(dictionary));
            }
            Enumeration enumeration = configs.elements();
            return enumeration;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dictionary load(String pid) throws IOException {
        Lock lock = this.globalLock.readLock();
        try {
            lock.lock();
            Dictionary loaded = this.cache.get(pid);
            if (loaded == null && !this.fullyLoaded) {
                lock.unlock();
                lock = this.globalLock.writeLock();
                lock.lock();
                loaded = this.cache.get(pid);
                if (loaded == null) {
                    loaded = this.pm.load(pid);
                    this.cache.put(pid, this.copy(loaded));
                }
            }
            CaseInsensitiveDictionary caseInsensitiveDictionary = this.copy(loaded);
            return caseInsensitiveDictionary;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store(String pid, Dictionary properties) throws IOException {
        Lock lock = this.globalLock.writeLock();
        try {
            lock.lock();
            this.pm.store(pid, properties);
            this.cache.put(pid, this.copy(properties));
        }
        finally {
            lock.unlock();
        }
    }

    CaseInsensitiveDictionary copy(Dictionary source) {
        return new CaseInsensitiveDictionary(source);
    }
}

