/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.deployment.node.runtime;

import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.util.DOLUtils;
import java.util.Map;
import java.util.logging.Level;
import org.glassfish.ejb.deployment.descriptor.IASEjbCMPEntityDescriptor;
import org.glassfish.ejb.deployment.descriptor.runtime.IASEjbCMPFinder;
import org.glassfish.ejb.deployment.descriptor.runtime.PrefetchDisabledDescriptor;
import org.glassfish.ejb.deployment.node.runtime.FinderNode;
import org.glassfish.ejb.deployment.node.runtime.PrefetchDisabledNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CmpNode
extends DeploymentDescriptorNode<IASEjbCMPEntityDescriptor> {
    protected IASEjbCMPEntityDescriptor descriptor;

    public CmpNode() {
        this.registerElementHandler(new XMLElement("finder"), FinderNode.class);
        this.registerElementHandler(new XMLElement("prefetch-disabled"), PrefetchDisabledNode.class);
    }

    public IASEjbCMPEntityDescriptor getDescriptor() {
        Object desc;
        if (this.descriptor == null && (desc = this.getParentNode().getDescriptor()) instanceof IASEjbCMPEntityDescriptor) {
            this.descriptor = (IASEjbCMPEntityDescriptor)((Object)desc);
        }
        return this.descriptor;
    }

    protected Map getDispatchTable() {
        Map dispatchTable = super.getDispatchTable();
        dispatchTable.put("mapping-properties", "setMappingProperties");
        dispatchTable.put("is-one-one-cmp", null);
        return dispatchTable;
    }

    public void addDescriptor(Object newDescriptor) {
        this.getDescriptor();
        if (this.descriptor == null) {
            DOLUtils.getDefaultLogger().log(Level.WARNING, "enterprise.deployment.backend.addDescriptorFailure", new Object[]{newDescriptor, this});
            return;
        }
        if (newDescriptor instanceof IASEjbCMPFinder) {
            this.descriptor.addOneOneFinder((IASEjbCMPFinder)((Object)newDescriptor));
        } else if (newDescriptor instanceof PrefetchDisabledDescriptor) {
            this.descriptor.setPrefetchDisabledDescriptor((PrefetchDisabledDescriptor)((Object)newDescriptor));
        } else {
            super.addDescriptor((Object)this.descriptor);
        }
    }

    public Node writeDescriptor(Node parent, String nodeName, IASEjbCMPEntityDescriptor ejbDescriptor) {
        PrefetchDisabledDescriptor prefetchDisabledDesc;
        Node cmpNode = super.writeDescriptor(parent, nodeName, (Object)ejbDescriptor);
        CmpNode.appendTextChild((Node)cmpNode, (String)"mapping-properties", (String)ejbDescriptor.getMappingProperties());
        Map finders = ejbDescriptor.getOneOneFinders();
        if (!finders.isEmpty()) {
            Element findersNode = CmpNode.appendChild((Node)cmpNode, (String)"one-one-finders");
            FinderNode fn = new FinderNode();
            for (IASEjbCMPFinder aFinder : finders.values()) {
                fn.writeDescriptor((Node)findersNode, "finder", aFinder);
            }
        }
        if ((prefetchDisabledDesc = ejbDescriptor.getPrefetchDisabledDescriptor()) != null) {
            PrefetchDisabledNode prefetchDisabledNode = new PrefetchDisabledNode();
            prefetchDisabledNode.writeDescriptor(cmpNode, "prefetch-disabled", prefetchDisabledDesc);
        }
        return cmpNode;
    }
}

