/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.logging;

import java.util.ArrayList;
import java.util.Arrays;

public class ModuleToLoggerNameMapper {
    private static final Object[][] ModuleAndLoggerTable = new Object[][]{{"admin", new String[]{"javax.enterprise.system.tools.admin"}}, {"classloader", new String[]{"javax.enterprise.system.core.classloading"}}, {"cmp", new String[]{"javax.enterprise.system.container.cmp"}}, {"cmp-container", new String[]{"javax.enterprise.system.container.cmp"}}, {"configuration", new String[]{"javax.enterprise.system.core.config"}}, {"connector", new String[]{"javax.enterprise.resource.resourceadapter"}}, {"resource-adapter", new String[]{"javax.enterprise.resource.resourceadapter"}}, {"corba", new String[]{"javax.enterprise.resource.corba"}}, {"deployment", new String[]{"javax.enterprise.system.tools.deployment"}}, {"ejb-container", new String[]{"javax.enterprise.system.container.ejb"}}, {"javamail", new String[]{"javax.enterprise.resource.javamail"}}, {"jaxr", new String[]{"javax.enterprise.system.webservices.registry"}}, {"jaxrpc", new String[]{"javax.enterprise.system.webservices.rpc"}}, {"jdo", new String[]{"javax.enterprise.resource.jdo"}}, {"jms", new String[]{"javax.enterprise.resource.jms", "javax.resourceadapter.mqjmsra"}}, {"jta", new String[]{"javax.enterprise.resource.jta"}}, {"jts", new String[]{"javax.enterprise.system.core.transaction"}}, {"mdb-container", new String[]{"javax.enterprise.system.container.ejb.mdb"}}, {"naming", new String[]{"javax.enterprise.system.core.naming"}}, {"saaj", new String[]{"javax.enterprise.system.webservices.saaj"}}, {"security", new String[]{"javax.enterprise.system.core.security"}}, {"self-management", new String[]{"javax.enterprise.system.core.selfmanagement"}}, {"synchronization", new String[]{"javax.ee.enterprise.system.tools.synchronization"}}, {"web-container", new String[]{"javax.enterprise.system.container.web", "org.apache.catalina", "org.apache.coyote", "org.apache.jasper"}}, {"group-management-service", new String[]{"javax.org.glassfish.gms"}}, {"node-agent", new String[]{"javax.ee.enterprise.system.nodeagent"}}, {"util", new String[]{"javax.enterprise.system.util"}}, {"core", new String[]{"javax.enterprise.system.core"}}, {"server", new String[]{"javax.enterprise.system"}}};

    public static String getModuleName(String loggerName) {
        for (int i = 0; i < ModuleAndLoggerTable.length; ++i) {
            Object[] dim = ModuleAndLoggerTable[i];
            String modName = (String)dim[0];
            String[] loggerNames = (String[])dim[1];
            for (int j = 0; loggerNames != null && j < loggerNames.length; ++j) {
                String name = loggerNames[j];
                if (!loggerName.equals(name)) continue;
                return modName;
            }
        }
        return null;
    }

    public static String[] getLoggerNames(String moduleName) {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < ModuleAndLoggerTable.length; ++i) {
            Object[] dim = ModuleAndLoggerTable[i];
            String modName = (String)dim[0];
            String[] loggerNames = (String[])dim[1];
            if (loggerNames == null) continue;
            if (moduleName == null) {
                result.addAll(Arrays.asList(loggerNames));
                continue;
            }
            if (!moduleName.equals(modName)) continue;
            result.addAll(Arrays.asList(loggerNames));
            break;
        }
        String[] lNames = new String[result.size()];
        return result.toArray(lNames);
    }
}

