/*
 * Decompiled with CFR 0.152.
 */
package com.sun.data.provider.impl;

import com.sun.data.provider.DataProviderException;
import com.sun.data.provider.RowKey;
import com.sun.data.provider.SortCriteria;
import com.sun.data.provider.TableDataProvider;
import com.sun.data.provider.TableDataSorter;
import java.text.Collator;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;

public class BasicTableDataSorter
implements TableDataSorter {
    protected SortCriteria[] sortCriteria;
    protected Locale sortLocale;

    public BasicTableDataSorter() {
    }

    public BasicTableDataSorter(SortCriteria[] sortCriteria) {
        this.sortCriteria = sortCriteria;
    }

    public BasicTableDataSorter(Locale sortLocale) {
        this.sortLocale = sortLocale;
    }

    public BasicTableDataSorter(SortCriteria[] sortCriteria, Locale sortLocale) {
        this.sortCriteria = sortCriteria;
        this.sortLocale = sortLocale;
    }

    public void setSortCriteria(SortCriteria[] sortCriteria) {
        this.sortCriteria = sortCriteria;
    }

    public SortCriteria[] getSortCriteria() {
        return this.sortCriteria;
    }

    public void setSortLocale(Locale sortLocale) {
        this.sortLocale = sortLocale;
    }

    public Locale getSortLocale() {
        return this.sortLocale;
    }

    public RowKey[] sort(TableDataProvider provider, RowKey[] rows) throws DataProviderException {
        int i;
        if (rows == null || rows.length == 0) {
            return RowKey.EMPTY_ARRAY;
        }
        int[] sortIndex = new int[rows.length];
        for (i = 0; i < rows.length; ++i) {
            sortIndex[i] = i;
        }
        if (this.sortCriteria != null) {
            for (i = this.sortCriteria.length - 1; i >= 0; --i) {
                this.mergeSort(sortIndex, 0, sortIndex.length - 1, this.sortCriteria[i], provider, rows);
            }
        }
        RowKey[] sortedRows = new RowKey[sortIndex.length];
        for (int i2 = 0; i2 < sortedRows.length; ++i2) {
            sortedRows[i2] = rows[sortIndex[i2]];
        }
        return sortedRows;
    }

    private void mergeSort(int[] a, int first, int last, SortCriteria sc, TableDataProvider tdp, RowKey[] rows) throws DataProviderException {
        if (first < last) {
            int mid = (first + last) / 2;
            this.mergeSort(a, first, mid, sc, tdp, rows);
            this.mergeSort(a, mid + 1, last, sc, tdp, rows);
            this.merge(a, first, mid, last, sc, tdp, rows);
        }
    }

    private void merge(int[] a, int first, int mid, int last, SortCriteria sc, TableDataProvider tdp, RowKey[] rows) throws DataProviderException {
        int i;
        int length = last - first + 1;
        int[] tmp = new int[length];
        int row1 = 0;
        int row2 = mid - first + 1;
        for (i = 0; i < length; ++i) {
            tmp[i] = a[first + i];
        }
        for (i = 0; i < length; ++i) {
            if (row2 <= last - first) {
                if (row1 <= mid - first) {
                    if (sc.isAscending() ? this.compare(sc, tdp, rows[tmp[row1]], rows[tmp[row2]]) > 0 : this.compare(sc, tdp, rows[tmp[row1]], rows[tmp[row2]]) < 0) {
                        a[first + i] = tmp[row2++];
                        continue;
                    }
                    a[first + i] = tmp[row1++];
                    continue;
                }
                a[first + i] = tmp[row2++];
                continue;
            }
            a[first + i] = tmp[row1++];
        }
    }

    private int compare(SortCriteria sc, TableDataProvider tdp, RowKey row1, RowKey row2) throws DataProviderException {
        Object o1 = sc.getSortValue(tdp, row1);
        Object o2 = sc.getSortValue(tdp, row2);
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == o2) {
            return 0;
        }
        if (o1 == null) {
            return 1;
        }
        if (o2 == null) {
            return -1;
        }
        if (o1 instanceof Comparator && o2 instanceof Comparator) {
            return ((Comparator)o1).compare(o1, o2);
        }
        if (o1 instanceof Character && o2 instanceof Character) {
            return ((Character)o1).compareTo(o2);
        }
        if (o1 instanceof Date && o2 instanceof Date) {
            return ((Date)o1).compareTo(o2);
        }
        if (o1 instanceof Number && o2 instanceof Number) {
            Double d1 = new Double(((Number)o1).doubleValue());
            Double d2 = new Double(((Number)o2).doubleValue());
            return d1.compareTo(d2);
        }
        if (o1 instanceof Boolean && o2 instanceof Boolean) {
            boolean b2;
            boolean b1 = (Boolean)o1;
            if (b1 == (b2 = ((Boolean)o2).booleanValue())) {
                return 0;
            }
            if (b1) {
                return -1;
            }
            return 1;
        }
        if (o1 instanceof String && o2 instanceof String) {
            String s1 = (String)o1;
            String s2 = (String)o2;
            Collator collator = Collator.getInstance(this.sortLocale != null ? this.sortLocale : Locale.getDefault());
            collator.setStrength(3);
            return collator.compare(s1, s2);
        }
        String s1 = o1.toString();
        String s2 = o2.toString();
        return s1.compareTo(s2);
    }
}

