/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.osgijpa;

import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.List;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.persistence.tools.weaving.jpa.StaticWeaveProcessor;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.deployment.archive.WritableArchive;
import org.glassfish.internal.api.Globals;
import org.glassfish.osgijavaeebase.BundleClassLoader;
import org.glassfish.osgijavaeebase.JarHelper;
import org.glassfish.osgijavaeebase.OSGiArchiveHandler;
import org.glassfish.osgijavaeebase.OSGiBundleArchive;
import org.glassfish.osgijpa.JPAEnhancer;
import org.glassfish.osgijpa.dd.Persistence;
import org.osgi.framework.Bundle;

class EclipseLinkEnhancer
implements JPAEnhancer {
    private static Logger logger = Logger.getLogger(EclipseLinkEnhancer.class.getPackage().getName());
    ArchiveFactory archiveFactory = (ArchiveFactory)Globals.get(ArchiveFactory.class);
    private static final String elPackage = "org.eclipse.persistence.*";

    EclipseLinkEnhancer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream enhance(Bundle b, List<Persistence> persistenceXMLs) throws IOException {
        InputStream inputStream;
        block11: {
            File explodedDir = EclipseLinkEnhancer.makeFile(b);
            boolean dirDeployment = explodedDir != null ? explodedDir.isDirectory() : false;
            try {
                if (!dirDeployment) {
                    explodedDir = this.explode(b);
                }
                final File enhancedDir = EclipseLinkEnhancer.makeTmpDir("enhanced-osgiapp");
                FileUtils.copyTree((File)explodedDir, (File)enhancedDir);
                BundleClassLoader cl = new BundleClassLoader(b);
                for (Persistence persistenceXML : persistenceXMLs) {
                    String puRoot = persistenceXML.getPURoot();
                    File source = new File(explodedDir, puRoot);
                    File target = new File(enhancedDir, puRoot);
                    try {
                        this.enhance(source, target, (ClassLoader)cl, persistenceXML);
                    }
                    catch (URISyntaxException e) {
                        throw new RuntimeException(e);
                    }
                }
                this.updateManifest(new File(enhancedDir, "META-INF/MANIFEST.MF"));
                inputStream = JarHelper.makeJar((File)enhancedDir, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (FileUtils.whack((File)enhancedDir)) {
                            logger.logp(Level.INFO, "EclipseLinkEnhancer", "enhance", "Deleted {0} ", new Object[]{enhancedDir});
                        } else {
                            logger.logp(Level.INFO, "EclipseLinkEnhancer", "enhance", "Unable to delete {0} ", new Object[]{enhancedDir});
                        }
                    }
                });
                if (dirDeployment) break block11;
            }
            catch (Throwable throwable) {
                if (!dirDeployment) {
                    if (FileUtils.whack((File)explodedDir)) {
                        logger.logp(Level.INFO, "EclipseLinkEnhancer", "enhance", "Deleted {0} ", new Object[]{explodedDir});
                    } else {
                        logger.logp(Level.WARNING, "EclipseLinkEnhancer", "enhance", "Unable to delete " + explodedDir);
                    }
                }
                throw throwable;
            }
            if (FileUtils.whack((File)explodedDir)) {
                logger.logp(Level.INFO, "EclipseLinkEnhancer", "enhance", "Deleted {0} ", new Object[]{explodedDir});
            } else {
                logger.logp(Level.WARNING, "EclipseLinkEnhancer", "enhance", "Unable to delete " + explodedDir);
            }
        }
        return inputStream;
    }

    private void enhance(File source, File target, ClassLoader cl, Persistence persistenceXML) throws IOException, URISyntaxException {
        logger.logp(Level.INFO, "EclipseLinkEnhancer", "enhance", "Source = {0}, Target = {1}", new Object[]{source, target});
        StaticWeaveProcessor proc = new StaticWeaveProcessor(source, target);
        proc.setClassLoader(cl);
        proc.performWeaving();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateManifest(File mf) throws IOException {
        Manifest m = new Manifest();
        FileInputStream is = new FileInputStream(mf);
        try {
            m.read(is);
        }
        finally {
            is.close();
        }
        String value = m.getMainAttributes().getValue("DynamicImport-Package");
        value = value != null ? value.concat(", org.eclipse.persistence.*") : elPackage;
        m.getMainAttributes().putValue("DynamicImport-Package", value);
        m.getMainAttributes().putValue("GlassFish-StaticallyWeaved", "true");
        FileOutputStream os = new FileOutputStream(mf);
        try {
            m.write(os);
        }
        finally {
            os.close();
        }
    }

    public static File makeTmpDir(String prefix) throws IOException {
        File tmpDir = File.createTempFile(prefix, "");
        tmpDir.delete();
        tmpDir = new File(tmpDir.getAbsolutePath());
        tmpDir.deleteOnExit();
        if (tmpDir.mkdirs()) {
            return tmpDir;
        }
        throw new IOException("Not able to create tmpdir " + tmpDir);
    }

    public static File makeFile(Bundle b) {
        try {
            return new File(new OSGiBundleArchive(b).getURI());
        }
        catch (Exception exception) {
            return null;
        }
    }

    private File explode(Bundle b) throws IOException {
        File explodedDir = EclipseLinkEnhancer.makeTmpDir("osgiapp");
        WritableArchive targetArchive = this.archiveFactory.createArchive(explodedDir);
        new OSGiArchiveHandler().expand((ReadableArchive)new OSGiBundleArchive(b), targetArchive, null);
        logger.logp(Level.INFO, "EclipseLinkEnhancer", "explode", "Exploded bundle {0} at {1} ", new Object[]{b, explodedDir});
        return explodedDir;
    }
}

