/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.encoding.simpletype;

import com.sun.xml.rpc.encoding.DeserializationException;
import com.sun.xml.rpc.encoding.simpletype.SimpleTypeEncoder;
import com.sun.xml.rpc.encoding.simpletype.SimpleTypeEncoderBase;
import com.sun.xml.rpc.streaming.XMLReader;
import com.sun.xml.rpc.streaming.XMLWriter;

public class XSDUnsignedIntEncoder
extends SimpleTypeEncoderBase {
    private static final SimpleTypeEncoder encoder = new XSDUnsignedIntEncoder();
    private static final long upperBound = 0xFFFFFFFFL;

    private XSDUnsignedIntEncoder() {
    }

    public static SimpleTypeEncoder getInstance() {
        return encoder;
    }

    @Override
    public String objectToString(Object obj, XMLWriter writer) throws Exception {
        if (obj == null) {
            return null;
        }
        return ((Long)obj).toString();
    }

    @Override
    public Object stringToObject(String str, XMLReader reader) throws Exception {
        if (str == null) {
            return null;
        }
        try {
            Long value = Long.valueOf(str);
            if (value < 0L || value > 0xFFFFFFFFL) {
                throw new DeserializationException("xsd.invalid.unsignedInt", str);
            }
            return value;
        }
        catch (NumberFormatException e) {
            throw new DeserializationException("xsd.invalid.unsignedInt", str);
        }
    }

    @Override
    public void writeValue(Object obj, XMLWriter writer) throws Exception {
        writer.writeCharsUnquoted(this.objectToString(obj, writer));
    }
}

