/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.server;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.api.container.Container;
import org.glassfish.api.container.Sniffer;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.data.ContainerRegistry;
import org.glassfish.internal.data.EngineInfo;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Service;

@Service
public class ContainerStarter {
    @Inject
    ServiceLocator serviceLocator;
    @Inject
    ServiceLocator habitat;
    @Inject
    Logger logger;
    @Inject
    ServerEnvironmentImpl env;
    @Inject
    ContainerRegistry registry;

    public Collection<EngineInfo> startContainer(Sniffer sniffer) {
        assert (sniffer != null);
        String containerName = sniffer.getModuleType();
        assert (containerName != null);
        try {
            Object[] modules = sniffer.setup(null, this.logger);
            this.logger.logp(Level.FINE, "ContainerStarter", "startContainer", "Sniffer {0} set up following modules: {1}", new Object[]{sniffer, modules != null ? Arrays.toString(modules) : ""});
        }
        catch (FileNotFoundException fnf) {
            this.logger.log(Level.SEVERE, fnf.getMessage());
            return null;
        }
        catch (IOException ioe) {
            this.logger.log(Level.SEVERE, ioe.getMessage(), ioe);
            return null;
        }
        HashMap<String, EngineInfo> containers = new HashMap<String, EngineInfo>();
        for (String name : sniffer.getContainersNames()) {
            ServiceHandle provider = this.serviceLocator.getServiceHandle(Container.class, name, new Annotation[0]);
            if (provider == null) {
                this.logger.severe("Cannot find Container named " + name + ", so unable to start " + sniffer.getModuleType() + " container");
                return null;
            }
            EngineInfo info = new EngineInfo(provider, sniffer, null);
            containers.put(name, info);
        }
        for (Map.Entry entry : containers.entrySet()) {
            this.registry.addContainer((String)entry.getKey(), (EngineInfo)entry.getValue());
        }
        return containers.values();
    }
}

