/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.connectors.admin.cli;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.connectors.config.ResourceAdapterConfig;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.types.Property;

@TargetType(value={CommandTarget.DAS, CommandTarget.DOMAIN, CommandTarget.CLUSTER, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTERED_INSTANCE})
@Service(name="list-resource-adapter-configs")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@ExecuteOn(value={RuntimeType.DAS})
@I18n(value="list.resource.adapter.configs")
@RestEndpoints(value={@RestEndpoint(configBean=Resources.class, opType=RestEndpoint.OpType.GET, path="list-resource-adapter-configs", description="list-resource-adapter-configs")})
public class ListResourceAdapterConfigs
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ListResourceAdapterConfigs.class);
    @Param(name="raname", optional=true)
    private String raName;
    @Param(name="long", optional=true, defaultValue="false", shortName="l", alias="verbose")
    private Boolean long_opt;
    @Param(primary=true, optional=true, defaultValue="server", alias="targetName", obsolete=true)
    private String target;
    @Inject
    private Domain domain;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            HashMap<String, List> raMap = new HashMap<String, List>();
            boolean raExists = false;
            Collection resourceAdapterConfigs = this.domain.getResources().getResources(ResourceAdapterConfig.class);
            for (ResourceAdapterConfig resourceAdapterConfig : resourceAdapterConfigs) {
                if (this.raName != null && !this.raName.isEmpty()) {
                    if (!resourceAdapterConfig.getResourceAdapterName().equals(this.raName)) continue;
                    raMap.put(this.raName, resourceAdapterConfig.getProperty());
                    raExists = true;
                    break;
                }
                raMap.put(resourceAdapterConfig.getResourceAdapterName(), resourceAdapterConfig.getProperty());
            }
            if (this.raName != null && !this.raName.isEmpty() && !raExists) {
                report.setMessage(localStrings.getLocalString("delete.resource.adapter.config.notfound", "Resource adapter {0} not found.", new Object[]{this.raName}));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            if (this.long_opt.booleanValue()) {
                for (Map.Entry entry : raMap.entrySet()) {
                    ActionReport.MessagePart part = report.getTopMessagePart().addChild();
                    part.setMessage((String)entry.getKey());
                    for (Property prop : (List)entry.getValue()) {
                        ActionReport.MessagePart propPart = part.addChild();
                        propPart.setMessage("\t" + prop.getName() + "=" + prop.getValue());
                    }
                }
            } else {
                for (String string : raMap.keySet()) {
                    ActionReport.MessagePart part = report.getTopMessagePart().addChild();
                    part.setMessage(string);
                }
            }
        }
        catch (Exception e) {
            String failMsg = localStrings.getLocalString("list.resource.adapter.configs.fail", "Unable to list resource adapter configs.");
            Logger.getLogger(ListResourceAdapterConfigs.class.getName()).log(Level.SEVERE, failMsg, e);
            report.setMessage(failMsg + " " + e.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

