/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http2.hpack;

import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.http2.hpack.BinaryRepresentationWriter;
import org.glassfish.grizzly.http2.hpack.HeaderTable;
import org.glassfish.grizzly.http2.hpack.IntegerWriter;
import org.glassfish.grizzly.http2.hpack.StringWriter;

abstract class IndexNameValueWriter
implements BinaryRepresentationWriter {
    private final int pattern;
    private final int prefix;
    private final IntegerWriter intWriter = new IntegerWriter();
    private final StringWriter nameWriter = new StringWriter();
    private final StringWriter valueWriter = new StringWriter();
    protected boolean indexedRepresentation;
    private static final int NEW = 0;
    private static final int NAME_PART_WRITTEN = 1;
    private static final int VALUE_WRITTEN = 2;
    private int state = 0;

    protected IndexNameValueWriter(int pattern, int prefix) {
        this.pattern = pattern;
        this.prefix = prefix;
    }

    IndexNameValueWriter index(int index) {
        this.indexedRepresentation = true;
        this.intWriter.configure(index, this.prefix, this.pattern);
        return this;
    }

    IndexNameValueWriter name(CharSequence name, boolean useHuffman) {
        this.indexedRepresentation = false;
        this.intWriter.configure(0, this.prefix, this.pattern);
        this.nameWriter.configure(name, useHuffman);
        return this;
    }

    IndexNameValueWriter value(CharSequence value, boolean useHuffman) {
        this.valueWriter.configure(value, useHuffman);
        return this;
    }

    @Override
    public boolean write(HeaderTable table, Buffer destination) {
        if (this.state < 1) {
            if (this.indexedRepresentation ? !this.intWriter.write(destination) : !this.intWriter.write(destination) || !this.nameWriter.write(destination)) {
                return false;
            }
            this.state = 1;
        }
        if (this.state < 2) {
            if (!this.valueWriter.write(destination)) {
                return false;
            }
            this.state = 2;
        }
        return this.state == 2;
    }

    @Override
    public IndexNameValueWriter reset() {
        this.intWriter.reset();
        if (!this.indexedRepresentation) {
            this.nameWriter.reset();
        }
        this.valueWriter.reset();
        this.state = 0;
        return this;
    }
}

