/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.model.jdo.impl;

import com.sun.jdo.api.persistence.model.ModelException;
import com.sun.jdo.api.persistence.model.ModelVetoException;
import com.sun.jdo.api.persistence.model.jdo.PersistenceElement;
import com.sun.jdo.api.persistence.model.jdo.impl.PersistenceElementImpl;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PersistenceElementCollection {
    private PersistenceElementImpl _owner;
    private PersistenceElement[] _elements;
    private Object[] _template;
    private String _propertyName;

    public PersistenceElementCollection() {
        this(null, null, null);
    }

    public PersistenceElementCollection(PersistenceElementImpl owner, String propertyName, Object[] template) {
        this._owner = owner;
        this._propertyName = propertyName;
        this._template = template;
    }

    public void changeElements(PersistenceElement[] elements, int action) throws ModelException {
        this.changeElements(Arrays.asList(elements), action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeElements(List elements, int action) throws ModelException {
        block11: {
            boolean changed = false;
            try {
                PersistenceElement[] oldElements = this.getElements();
                int oldLength = oldElements == null ? 0 : oldElements.length;
                int newLength = elements == null ? 0 : elements.size();
                ArrayList<Object> list = null;
                switch (action) {
                    case 0: {
                        list = elements;
                        changed = true;
                        break;
                    }
                    case 1: {
                        if (newLength <= 0) break;
                        list = oldLength == 0 ? new ArrayList() : new ArrayList<PersistenceElement>(Arrays.asList(oldElements));
                        list.addAll(elements);
                        changed = true;
                        break;
                    }
                    case -1: {
                        if (newLength <= 0 || oldLength <= 0) break;
                        list = new ArrayList<PersistenceElement>(Arrays.asList(oldElements));
                        list.removeAll(elements);
                        changed = true;
                    }
                }
                if (!changed) break block11;
                try {
                    this._owner.fireVetoableChange(this._propertyName, null, null);
                    this._elements = (PersistenceElement[])list.toArray(this._template);
                }
                catch (PropertyVetoException e) {
                    throw new ModelVetoException(e);
                }
            }
            finally {
                if (changed) {
                    this._owner.firePropertyChange(this._propertyName, null, null);
                }
            }
        }
    }

    public PersistenceElement[] getElements() {
        return this._elements;
    }

    public PersistenceElement getElement(String name) {
        PersistenceElement[] elements = this.getElements();
        int count = elements != null ? elements.length : 0;
        for (int i = 0; i < count; ++i) {
            PersistenceElement element = elements[i];
            if (!name.equals(element.getName())) continue;
            return element;
        }
        return null;
    }

    public PersistenceElementImpl getOwner() {
        return this._owner;
    }

    public void setOwner(PersistenceElementImpl owner) {
        this._owner = owner;
    }

    public Object[] getTemplate() {
        return this._template;
    }

    public void setTemplate(Object[] template) {
        this._template = template;
    }

    public String getPropertyName() {
        return this._propertyName;
    }

    public void setPropertyName(String propertyName) {
        this._propertyName = propertyName;
    }

    public void setElements(PersistenceElement[] elements) {
        this._elements = elements;
    }
}

