/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.cms.impl.client;

import com.sun.enterprise.ee.cms.core.ActionException;
import com.sun.enterprise.ee.cms.core.CallBack;
import com.sun.enterprise.ee.cms.core.JoinNotificationAction;
import com.sun.enterprise.ee.cms.core.Signal;
import com.sun.enterprise.ee.cms.core.SignalAcquireException;
import com.sun.enterprise.ee.cms.core.SignalReleaseException;
import com.sun.enterprise.ee.cms.logging.GMSLogDomain;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JoinNotificationActionImpl
implements JoinNotificationAction {
    private final CallBack callBack;
    private Logger logger = GMSLogDomain.getLogger("ShoalLogger");

    public JoinNotificationActionImpl(CallBack callBack) {
        this.callBack = callBack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consumeSignal(Signal s) throws ActionException {
        boolean signalAcquired = false;
        try {
            s.acquire();
            signalAcquired = true;
            this.callBack.processNotification(s);
        }
        catch (SignalAcquireException e) {
            this.logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        finally {
            if (signalAcquired) {
                try {
                    s.release();
                }
                catch (SignalReleaseException e) {
                    this.logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
                }
            }
        }
    }
}

