/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.mappings;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.core.queries.CoreContainerPolicy;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.oxm.mappings.FragmentCollectionMapping;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.AttributeAccessor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.foundation.AbstractCompositeDirectCollectionMapping;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.mappings.XMLMapping;
import org.eclipse.persistence.oxm.mappings.nullpolicy.AbstractNullPolicy;
import org.eclipse.persistence.oxm.record.DOMRecord;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.eclipse.persistence.platform.xml.XMLPlatformFactory;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.sessions.Session;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class XMLFragmentCollectionMapping
extends AbstractCompositeDirectCollectionMapping
implements FragmentCollectionMapping<AbstractSession, AttributeAccessor, ContainerPolicy, ClassDescriptor, DatabaseField, Session, XMLRecord>,
XMLMapping {
    private boolean defaultEmptyContainer = true;
    private boolean isWriteOnly;
    private boolean reuseContainer;
    private AbstractNullPolicy wrapperNullPolicy;

    @Override
    public boolean isXMLMapping() {
        return true;
    }

    @Override
    public void initialize(AbstractSession session) throws DescriptorException {
        super.initialize(session);
    }

    public void setXPath(String xpathString) {
        this.setField(new XMLField(xpathString));
    }

    public String getXPath() {
        return this.getFieldName();
    }

    @Override
    public Object valueFromRow(AbstractRecord row, JoinedAttributeManager joinManager, ObjectBuildingQuery sourceQuery, CacheKey cacheKey, AbstractSession executionSession, boolean isTargetProtected, Boolean[] wasCacheUsed) throws DatabaseException {
        CoreContainerPolicy cp = this.getContainerPolicy();
        Object fieldValue = ((DOMRecord)row).getValuesIndicatingNoEntry((DatabaseField)this.getField(), true);
        Vector nestedRows = null;
        if (fieldValue instanceof Vector) {
            nestedRows = (Vector)fieldValue;
        }
        if (nestedRows == null || nestedRows.isEmpty()) {
            if (this.reuseContainer) {
                Object currentObject = ((XMLRecord)row).getCurrentObject();
                Object container = ((AttributeAccessor)this.getAttributeAccessor()).getAttributeValueFromObject(currentObject);
                return container != null ? container : ((ContainerPolicy)cp).containerInstance();
            }
            return ((ContainerPolicy)cp).containerInstance();
        }
        Object result = null;
        if (this.reuseContainer) {
            Object currentObject = ((XMLRecord)row).getCurrentObject();
            Object container = ((AttributeAccessor)this.getAttributeAccessor()).getAttributeValueFromObject(currentObject);
            result = container != null ? container : ((ContainerPolicy)cp).containerInstance();
        } else {
            result = ((ContainerPolicy)cp).containerInstance();
        }
        Enumeration stream = nestedRows.elements();
        while (stream.hasMoreElements()) {
            Object next = stream.nextElement();
            if (next instanceof Element) {
                XMLPlatformFactory.getInstance().getXMLPlatform().namespaceQualifyFragment((Element)next);
            }
            ((ContainerPolicy)cp).addInto(next, result, executionSession);
        }
        return result;
    }

    @Override
    public void writeFromObjectIntoRow(Object object, AbstractRecord row, AbstractSession session, DatabaseMapping.WriteType writeType) {
        if (this.isReadOnly()) {
            return;
        }
        Object attributeValue = this.getAttributeValueFromObject(object);
        if (attributeValue == null) {
            row.put((DatabaseField)this.getField(), (Object)null);
            return;
        }
        CoreContainerPolicy cp = this.getContainerPolicy();
        Vector<Object> elements = new Vector<Object>(((ContainerPolicy)cp).sizeFor(attributeValue));
        Object iter = ((ContainerPolicy)cp).iteratorFor(attributeValue);
        while (((ContainerPolicy)cp).hasNext(iter)) {
            Object element = ((ContainerPolicy)cp).next(iter, session);
            if (element == null) continue;
            elements.addElement(element);
        }
        Object fieldValue = null;
        if (!elements.isEmpty()) {
            fieldValue = ((ClassDescriptor)this.getDescriptor()).buildFieldValueFromDirectValues(elements, this.elementDataTypeName, session);
        }
        row.put((DatabaseField)this.getField(), fieldValue);
    }

    @Override
    public boolean isAbstractCompositeDirectCollectionMapping() {
        return false;
    }

    @Override
    public void writeSingleValue(Object attributeValue, Object parent, XMLRecord row, AbstractSession session) {
        if (((XMLField)this.getField()).getLastXPathFragment().isAttribute()) {
            if (attributeValue instanceof Attr) {
                attributeValue = ((Attr)attributeValue).getValue();
            }
        } else if (((XMLField)this.getField()).getLastXPathFragment().nameIsText() && attributeValue instanceof Text) {
            attributeValue = ((Text)attributeValue).getNodeValue();
        }
        row.put((DatabaseField)this.getField(), attributeValue);
    }

    @Override
    public boolean isWriteOnly() {
        return this.isWriteOnly;
    }

    @Override
    public void setIsWriteOnly(boolean b) {
        this.isWriteOnly = b;
    }

    @Override
    public void preInitialize(AbstractSession session) throws DescriptorException {
        ((AttributeAccessor)this.getAttributeAccessor()).setIsWriteOnly(this.isWriteOnly());
        ((AttributeAccessor)this.getAttributeAccessor()).setIsReadOnly(this.isReadOnly());
        super.preInitialize(session);
    }

    @Override
    public void setAttributeValueInObject(Object object, Object value) throws DescriptorException {
        if (this.isWriteOnly()) {
            return;
        }
        super.setAttributeValueInObject(object, value);
    }

    @Override
    public boolean getReuseContainer() {
        return this.reuseContainer;
    }

    @Override
    public void setReuseContainer(boolean reuseContainer) {
        this.reuseContainer = reuseContainer;
    }

    @Override
    public boolean isDefaultEmptyContainer() {
        return this.defaultEmptyContainer;
    }

    @Override
    public void setDefaultEmptyContainer(boolean defaultEmptyContainer) {
        this.defaultEmptyContainer = defaultEmptyContainer;
    }

    @Override
    public AbstractNullPolicy getWrapperNullPolicy() {
        return this.wrapperNullPolicy;
    }

    @Override
    public void setWrapperNullPolicy(AbstractNullPolicy policy) {
        this.wrapperNullPolicy = policy;
    }
}

