/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.generate;

import com.sun.faces.config.beans.AttributeBean;
import com.sun.faces.config.beans.DescriptionBean;
import com.sun.faces.config.beans.FacesConfigBean;
import com.sun.faces.config.beans.RenderKitBean;
import com.sun.faces.config.beans.RendererBean;
import com.sun.faces.generate.Generator;
import com.sun.faces.generate.GeneratorUtil;
import com.sun.faces.generate.PropertyManager;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class RenderKitSpecificationGenerator
implements Generator {
    public static String DOCTYPE = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\"\"http://www.w3.org/TR/REC-html40/loose.dtd\">";
    private File baseDirectory;
    private File renderKitDirectory;
    private String renderKitId;
    private FacesConfigBean configBean;

    public RenderKitSpecificationGenerator(PropertyManager propManager) {
        this.renderKitId = propManager.getProperty("renderkit.id");
        this.baseDirectory = new File(System.getProperty("user.dir") + File.separatorChar + propManager.getProperty("base.output.dir") + File.separatorChar + "facesdoc");
        if (!this.baseDirectory.exists()) {
            this.baseDirectory.mkdirs();
        }
        this.renderKitDirectory = new File(this.baseDirectory, this.renderKitId);
        if (!this.renderKitDirectory.exists()) {
            this.renderKitDirectory.mkdirs();
        }
    }

    @Override
    public void generate(FacesConfigBean configBean) {
        this.configBean = configBean;
        try {
            RenderKitSpecificationGenerator.copyResourceToFile("com/sun/faces/generate/facesdoc/index.html", new File(this.baseDirectory, "index.html"));
            RenderKitSpecificationGenerator.copyResourceToFile("com/sun/faces/generate/facesdoc/stylesheet.css", new File(this.baseDirectory, "stylesheet.css"));
            this.generateAllRenderersFrame();
            this.generateRenderKitSummary();
            this.generateRenderersDocs();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String getFirstSentance(String para) throws Exception {
        int dot = para.indexOf(46);
        return para.substring(0, dot + 1);
    }

    private static void copyResourceToFile(String resourceName, File file) throws Exception {
        byte[] bytes = new byte[1024];
        FileOutputStream fos = new FileOutputStream(file);
        URL url = RenderKitSpecificationGenerator.getCurrentLoader(fos).getResource(resourceName);
        URLConnection conn = url.openConnection();
        conn.setUseCaches(false);
        BufferedInputStream bis = new BufferedInputStream(conn.getInputStream());
        int len = bis.read(bytes, 0, 1024);
        while (len != -1) {
            fos.write(bytes, 0, len);
            len = bis.read(bytes, 0, 1024);
        }
        fos.close();
        bis.close();
    }

    private static void writeStringToFile(String toWrite, File file) throws Exception {
        FileOutputStream fos = new FileOutputStream(file);
        byte[] bytes = toWrite.getBytes();
        fos.write(bytes);
        fos.close();
    }

    private static void appendResourceToStringBuffer(String resourceName, StringBuffer sb) throws Exception {
        char[] chars = new char[1024];
        URL url = RenderKitSpecificationGenerator.getCurrentLoader(sb).getResource(resourceName);
        URLConnection conn = url.openConnection();
        conn.setUseCaches(false);
        InputStreamReader isr = new InputStreamReader(conn.getInputStream());
        int len = isr.read(chars, 0, 1024);
        while (len != -1) {
            sb.append(chars, 0, len);
            len = isr.read(chars, 0, 1024);
        }
        isr.close();
    }

    private void generateAllRenderersFrame() throws Exception {
        StringBuffer sb = new StringBuffer(2048);
        RenderKitSpecificationGenerator.appendResourceToStringBuffer("com/sun/faces/generate/facesdoc/allrenderers-frame.top", sb);
        sb.append("<FONT size=\"+1\" CLASS=\"FrameHeadingFont\">\n");
        sb.append("<B>" + this.renderKitId + " RenderKit ");
        String implVersionNumber = System.getProperty("impl.version.number");
        if (null != implVersionNumber) {
            sb.append("(" + implVersionNumber + ")");
        }
        sb.append("</B></FONT>\n");
        sb.append("<BR>\n\n");
        sb.append("<DL CLASS=\"FrameItemFont\">\n\n");
        Map<String, ArrayList<RendererBean>> renderersByComponentFamily = GeneratorUtil.getComponentFamilyRendererMap(this.configBean, this.renderKitId);
        for (Map.Entry<String, ArrayList<RendererBean>> entry : renderersByComponentFamily.entrySet()) {
            String curFamily = entry.getKey();
            sb.append("  <DT>" + curFamily + "</DT>\n");
            List renderers = entry.getValue();
            for (RendererBean renderer : renderers) {
                String curType = renderer.getRendererType();
                DescriptionBean[] descriptions = renderer.getDescriptions();
                String enclosingDiv = null;
                String enclosingSpan = null;
                int[] divStart = new int[1];
                int[] spanStart = new int[1];
                if (null != descriptions) {
                    String localeStr = Locale.getDefault().getCountry().toLowerCase();
                    for (DescriptionBean cur : descriptions) {
                        if (null == cur.getLang() || -1 == localeStr.indexOf(cur.getLang().toLowerCase())) continue;
                        enclosingDiv = GeneratorUtil.getFirstDivFromString(renderer.getDescription(cur.getLang()).getDescription(), divStart);
                        enclosingSpan = GeneratorUtil.getFirstSpanFromString(renderer.getDescription(cur.getLang()).getDescription(), spanStart);
                        break;
                    }
                }
                if (null != enclosingDiv || null != enclosingSpan) {
                    String divOrSpan;
                    String string = divOrSpan = null != enclosingDiv ? enclosingDiv : enclosingSpan;
                    if (null != enclosingDiv && null != enclosingSpan) {
                        divOrSpan = spanStart[0] < divStart[0] ? enclosingSpan : enclosingDiv;
                    }
                    sb.append("  <DD>" + divOrSpan);
                    sb.append("<A HREF=\"" + this.renderKitId + "/" + curFamily + curType + ".html\" TARGET=\"rendererFrame\">" + curType + "</A>");
                    sb.append((null != enclosingDiv ? "</div>" : "</span>") + "</DD>\n");
                    continue;
                }
                sb.append("  <DD><A HREF=\"" + this.renderKitId + "/" + curFamily + curType + ".html\" TARGET=\"rendererFrame\">" + curType + "</A></DD>\n");
            }
        }
        sb.append("</dl>\n");
        RenderKitSpecificationGenerator.appendResourceToStringBuffer("com/sun/faces/generate/facesdoc/allrenderers-frame.bottom", sb);
        RenderKitSpecificationGenerator.writeStringToFile(sb.toString(), new File(this.baseDirectory, "allrenderers-frame.html"));
    }

    private void generateRenderKitSummary() throws Exception {
        DescriptionBean descBean;
        StringBuffer sb = new StringBuffer(2048);
        RenderKitSpecificationGenerator.appendResourceToStringBuffer("com/sun/faces/generate/facesdoc/renderkit-summary.top", sb);
        sb.append("<H2>" + this.renderKitId + " RenderKit ");
        String implVersionNumber = System.getProperty("impl.version.number");
        if (null != implVersionNumber) {
            sb.append("(" + implVersionNumber + ")");
        }
        sb.append("</H2>");
        sb.append("<BR>\n\n");
        RenderKitBean renderKit = this.configBean.getRenderKit(this.renderKitId);
        if (renderKit == null) {
            RenderKitBean[] kits = this.configBean.getRenderKits();
            if (kits == null) {
                throw new IllegalStateException("no RenderKits");
            }
            renderKit = kits[0];
            if (renderKit == null) {
                throw new IllegalStateException("no RenderKits");
            }
        }
        String description = null == (descBean = renderKit.getDescription("")) ? "" : descBean.getDescription();
        sb.append("<P>" + description + "</P>\n");
        sb.append("<P />");
        sb.append("<TABLE BORDER=\"1\" CELLPADDING=\"3\" CELLSPACING=\"0\" WIDTH=\"100%\">");
        sb.append("<TR BGCOLOR=\"#CCCCFF\" CLASS=\"TableHeadingColor\">\n");
        sb.append("<TD COLSPAN=\"3\"><FONT SIZE=\"+2\">\n");
        sb.append("<B>Renderer Summary</B></FONT></TD>\n");
        sb.append("\n");
        sb.append("<TR>\n");
        sb.append("<TH>component-family</TH>\n");
        sb.append("<TH>renderer-type</TH>\n");
        sb.append("<TH>description</TH>\n");
        sb.append("</TR>\n");
        Map<String, ArrayList<RendererBean>> renderersByComponentFamily = GeneratorUtil.getComponentFamilyRendererMap(this.configBean, this.renderKitId);
        for (Map.Entry<String, ArrayList<RendererBean>> entry : renderersByComponentFamily.entrySet()) {
            String curFamily = entry.getKey();
            List renderers = entry.getValue();
            sb.append("  <TR>\n");
            sb.append("    <TD rowspan=\"" + renderers.size() + "\">" + curFamily + "</TD>\n");
            Iterator rendererIter = renderers.iterator();
            while (rendererIter.hasNext()) {
                RendererBean renderer = (RendererBean)rendererIter.next();
                String curType = renderer.getRendererType();
                sb.append("    <TD><A HREF=\"" + curFamily + curType + ".html\" TARGET=\"rendererFrame\">" + curType + "</A></TD>\n");
                descBean = renderer.getDescription("");
                description = null == descBean ? "" : descBean.getDescription();
                sb.append("    <TD>" + RenderKitSpecificationGenerator.getFirstSentance(description) + "</TD>");
                if (!rendererIter.hasNext()) continue;
                sb.append("  </TR>\n");
                sb.append("  <TR>\n");
            }
            sb.append("  </TR>\n");
        }
        sb.append("</TABLE>\n\n");
        RenderKitSpecificationGenerator.appendResourceToStringBuffer("com/sun/faces/generate/facesdoc/renderkit-summary.bottom", sb);
        RenderKitSpecificationGenerator.writeStringToFile(sb.toString(), new File(this.renderKitDirectory, "renderkit-summary.html"));
    }

    private void generateRenderersDocs() throws Exception {
        RenderKitBean renderKit = this.configBean.getRenderKit(this.renderKitId);
        if (null == renderKit) {
            RenderKitBean[] kits = this.configBean.getRenderKits();
            if (kits == null) {
                throw new IllegalStateException("no RenderKits");
            }
            renderKit = kits[0];
            if (renderKit == null) {
                throw new IllegalStateException("no RenderKits");
            }
        }
        RendererBean[] renderers = renderKit.getRenderers();
        StringBuffer sb = new StringBuffer(2048);
        int len = renderers.length;
        for (int i = 0; i < len; ++i) {
            if (null == renderers[i]) {
                throw new IllegalStateException("null Renderer at index: " + i);
            }
            AttributeBean[] attributes = renderers[i].getAttributes();
            sb.append(DOCTYPE + "\n");
            sb.append("<html>\n");
            sb.append("<head>\n");
            sb.append("<title>\n");
            String componentFamily = renderers[i].getComponentFamily();
            String rendererType = renderers[i].getRendererType();
            String title = "<font size=\"-1\">component-family:</font> " + componentFamily + " <font size=\"-1\">renderer-type:</font> " + rendererType;
            sb.append(title + "\n");
            sb.append("</title>\n");
            sb.append("<link REL =\"stylesheet\" TYPE=\"text/css\" HREF=\"../stylesheet.css\" TITLE=\"Style\">\n");
            sb.append("</head>\n");
            sb.append("<script>\n");
            sb.append("function asd()\n");
            sb.append("{\n");
            sb.append("  parent.document.title=" + title + "\n");
            sb.append("}\n");
            sb.append("</SCRIPT>\n");
            sb.append("<body BGCOLOR=\"white\" onload=\"asd();\">\n");
            sb.append("\n");
            sb.append("<H2><font size=\"-1\">" + this.renderKitId + " render-kit</font>\n");
            sb.append("<br />\n");
            sb.append(title + "\n");
            sb.append("</H2>\n");
            sb.append("<HR />\n");
            DescriptionBean descBean = renderers[i].getDescription("");
            String description = null == descBean ? "" : descBean.getDescription();
            sb.append("<P>" + description + "</P>\n");
            if (renderers[i].isRendersChildren()) {
                sb.append("<P>This renderer is responsible for rendering its children.</P>");
            } else {
                sb.append("<P>This renderer is not responsible for rendering its children.</P>");
            }
            if (null == attributes || 0 < attributes.length) {
                sb.append("<HR />\n");
                sb.append("<a NAME=\"attributes\"><!-- --></a>\n");
                sb.append("\n");
                sb.append("<h3>Note:</h3>\n");
                sb.append("\n");
                sb.append("<p>Attributes with a <code class=\"changed_modified_2_2\">ignored-by-renderer</code> value of\n");
                sb.append("<code>true</code> are not interpreted by the renderer and are conveyed\n");
                sb.append("straight to the rendered markup, without checking for validity.  Attributes with a\n");
                sb.append("<code class=\"changed_modified_2_2\">ignored-by-renderer</code> value of <code>false</code> are interpreted\n");
                sb.append("by the renderer, and may or may not be checked for validity by the renderer.</p>\n");
                sb.append("\n");
                sb.append("<table BORDER=\"1\" CELLPADDING=\"3\" CELLSPACING=\"0\" WIDTH=\"100%\">\n");
                sb.append("<tr BGCOLOR=\"#CCCCFF\" CLASS=\"TableHeadingColor\">\n");
                sb.append("<td COLSPAN=\"5\"><font SIZE=\"+2\">\n");
                sb.append("<b>Attributes</b></font></td>\n");
                sb.append("</tr>\n");
                sb.append("<tr BGCOLOR=\"#CCCCFF\" CLASS=\"TableHeadingColor\">\n");
                sb.append("<th><b>attribute-name</b></th>\n");
                sb.append("<th><b class=\"changed_modified_2_2\">ignored-by-renderer</b></th>\n");
                sb.append("<th><b>attribute-class</b></th>\n");
                sb.append("<th><b>description</b></th>\n");
                sb.append("<th><b>default-value</b></th>\n");
                sb.append("</tr>\n");
                sb.append("\t    \n");
                if (attributes != null) {
                    int attrLen = attributes.length;
                    for (int j = 0; j < attrLen; ++j) {
                        if (attributes[j].isAttributeIgnoredForRenderer()) continue;
                        sb.append("<tr BGCOLOR=\"white\" CLASS=\"TableRowColor\">\n");
                        sb.append("<td ALIGN=\"right\" VALIGN=\"top\" WIDTH=\"1%\"><code>\n");
                        sb.append("&nbsp;" + attributes[j].getAttributeName() + "\n");
                        sb.append("</td>\n");
                        sb.append("<td ALIGN=\"right\" VALIGN=\"top\">" + attributes[j].isPassThrough() + "</td>\n");
                        sb.append("<td><code>" + attributes[j].getAttributeClass() + "</code></td>\n");
                        descBean = attributes[j].getDescription("");
                        description = null == descBean ? "" : descBean.getDescription();
                        sb.append("<td>" + description + "</td>\n");
                        String defaultValue = attributes[j].getDefaultValue();
                        if (null == defaultValue) {
                            defaultValue = "undefined";
                        }
                        sb.append("<td>" + defaultValue + "<td>\n");
                        sb.append("</tr>\n");
                    }
                }
                sb.append("</table>\n");
            } else {
                sb.append("<p>This renderer-type has no attributes</p>\n");
            }
            sb.append("<hr>\n");
            sb.append("Copyright (c) 2003-2017 Oracle America, Inc. All Rights Reserved.\n");
            sb.append("</body>\n");
            sb.append("</html>\n");
            RenderKitSpecificationGenerator.writeStringToFile(sb.toString(), new File(this.renderKitDirectory, componentFamily + rendererType + ".html"));
            sb.delete(0, sb.length());
        }
    }

    private static ClassLoader getCurrentLoader(Object fallbackClass) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = fallbackClass.getClass().getClassLoader();
        }
        return loader;
    }

    public static void main(String[] args) throws Exception {
        PropertyManager propManager = PropertyManager.newInstance(args[0]);
        RenderKitSpecificationGenerator generator = new RenderKitSpecificationGenerator(propManager);
        generator.generate(GeneratorUtil.getConfigBean(args[1]));
    }
}

