/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.weld;

import com.sun.enterprise.container.common.spi.util.ComponentEnvManager;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import javax.inject.Inject;
import javax.naming.NamingException;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.api.naming.NamedNamingObjectProxy;
import org.glassfish.api.naming.NamespacePrefixes;
import org.glassfish.weld.WeldDeployer;
import org.jboss.weld.bootstrap.WeldBootstrap;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jvnet.hk2.annotations.Service;

@Service
@NamespacePrefixes(value={"java:comp/BeanManager"})
public class BeanManagerNamingProxy
implements NamedNamingObjectProxy {
    @Inject
    private ComponentEnvManager compEnvManager;
    @Inject
    private InvocationManager invocationManager;
    @Inject
    private WeldDeployer weldDeployer;
    static final String BEAN_MANAGER_CONTEXT = "java:comp/BeanManager";

    public Object handle(String name) throws NamingException {
        BeanManagerImpl beanManager;
        block9: {
            beanManager = null;
            if (BEAN_MANAGER_CONTEXT.equals(name)) {
                try {
                    ComponentInvocation inv = this.invocationManager.getCurrentInvocation();
                    if (inv == null) break block9;
                    JndiNameEnvironment componentEnv = this.compEnvManager.getJndiNameEnvironment(inv.getComponentId());
                    if (componentEnv != null) {
                        BeanDeploymentArchive bda;
                        BundleDescriptor bundle = null;
                        if (componentEnv instanceof EjbDescriptor) {
                            bundle = (BundleDescriptor)((EjbDescriptor)componentEnv).getEjbBundleDescriptor().getModuleDescriptor().getDescriptor();
                        } else if (componentEnv instanceof WebBundleDescriptor) {
                            bundle = (BundleDescriptor)componentEnv;
                        }
                        if (bundle != null && (bda = this.weldDeployer.getBeanDeploymentArchiveForBundle(bundle)) != null) {
                            WeldBootstrap bootstrap = this.weldDeployer.getBootstrapForApp(bundle.getApplication());
                            beanManager = bootstrap.getManager(bda);
                        }
                        if (beanManager == null) {
                            throw new IllegalStateException("Cannot resolve bean manager");
                        }
                        break block9;
                    }
                    throw new IllegalStateException("No invocation context found");
                }
                catch (Throwable t) {
                    NamingException ne = new NamingException("Error retrieving java:comp/BeanManager");
                    ne.initCause(t);
                    throw ne;
                }
            }
        }
        return beanManager;
    }
}

