/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.probe;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.enterprise.inject.Vetoed;
import org.jboss.weld.probe.Components;
import org.jboss.weld.probe.JsonDataProvider;
import org.jboss.weld.probe.Resource;

@Vetoed
final class Exports {
    private Exports() {
    }

    static byte[] exportJsonData(JsonDataProvider jsonDataProvider) throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(bytes));
        Exports.addEntry(out, "deployment", jsonDataProvider.receiveDeployment());
        Exports.addEntry(out, "observers", jsonDataProvider.receiveObservers(0, 0, null, Resource.Representation.FULL.toString()));
        Exports.addEntry(out, "beans", jsonDataProvider.receiveBeans(0, 0, null, Resource.Representation.FULL.toString()));
        Exports.addEntry(out, "fired-events", jsonDataProvider.receiveEvents(0, 0, null));
        Exports.addEntry(out, "invocation-trees", jsonDataProvider.receiveInvocations(0, 0, null, Resource.Representation.FULL.toString()));
        Exports.addEntry(out, "contexts", jsonDataProvider.receiveContexts());
        for (String contextKey : Components.INSPECTABLE_SCOPES.keySet()) {
            Exports.addEntry(out, "context-" + contextKey, jsonDataProvider.receiveContext(contextKey));
        }
        out.close();
        return bytes.toByteArray();
    }

    private static void addEntry(ZipOutputStream out, String baseName, String data) throws IOException {
        out.putNextEntry(new ZipEntry(baseName + ".json"));
        out.write(data.getBytes(StandardCharsets.UTF_8));
    }
}

