/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.rs.util.xmladapters;

import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.ItemLinks;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.LinkV2;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedRest;
import org.eclipse.persistence.jpa.rs.PersistenceContext;
import org.eclipse.persistence.jpa.rs.exceptions.JPARSException;
import org.eclipse.persistence.jpa.rs.features.ItemLinksBuilder;
import org.eclipse.persistence.jpa.rs.util.HrefHelper;
import org.eclipse.persistence.jpa.rs.util.IdHelper;

public class ReferenceAdapterV2<T extends PersistenceWeavedRest>
extends XmlAdapter<T, T> {
    protected PersistenceContext context;

    public ReferenceAdapterV2() {
    }

    public ReferenceAdapterV2(PersistenceContext context) {
        this.context = context;
    }

    public T marshal(T o) throws Exception {
        if (o == null) {
            return null;
        }
        String href = HrefHelper.buildEntityHref(this.context, o.getClass().getSimpleName(), IdHelper.stringifyId(o, o.getClass().getSimpleName(), this.context));
        if (o._persistence_getLinks() == null) {
            ItemLinks itemLinks = new ItemLinksBuilder().addCanonical(href).build();
            o._persistence_setLinks(itemLinks);
        } else {
            ItemLinks itemLinks = o._persistence_getLinks();
            LinkV2 canonicalLink = itemLinks.getCanonicalLink();
            if (canonicalLink == null) {
                o._persistence_getLinks().addLink(new LinkV2("canonical", href));
            }
        }
        return o;
    }

    public T unmarshal(T o) throws Exception {
        if (o == null) {
            return null;
        }
        if (this.context == null) {
            return o;
        }
        if (o._persistence_getLinks() != null && o._persistence_getLinks().getLinks() != null && !o._persistence_getLinks().getLinks().isEmpty()) {
            ItemLinks itemLinks = o._persistence_getLinks();
            LinkV2 canonicalLink = itemLinks.getCanonicalLink();
            if (canonicalLink != null && canonicalLink.getHref() != null) {
                return this.loadEntity(canonicalLink.getHref());
            }
            LinkV2 selfLink = itemLinks.getSelfLink();
            if (selfLink != null && selfLink.getHref() != null) {
                return this.loadEntity(selfLink.getHref());
            }
        }
        return o;
    }

    private T loadEntity(String href) throws Exception {
        String uri = href.replace("\\/", "/");
        String entityType = uri.substring(uri.indexOf("/entity/"), uri.lastIndexOf(47));
        entityType = entityType.substring(entityType.lastIndexOf("/") + 1);
        String entityId = uri.substring(uri.lastIndexOf("/") + 1);
        ClassDescriptor descriptor = this.context.getDescriptor(entityType);
        Object id = IdHelper.buildId(this.context, descriptor.getAlias(), entityId);
        return this.getObjectById(entityType, id);
    }

    private T getObjectById(String entityType, Object id) throws Exception {
        Object entity = this.context.find(null, entityType, id, null);
        if (entity != null) {
            return (T)((PersistenceWeavedRest)entity);
        }
        throw JPARSException.objectReferredByLinkDoesNotExist(entityType, id);
    }
}

