/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.util.jmx;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.regex.Pattern;
import javax.management.ObjectName;
import org.glassfish.admin.amx.util.EnumerationIterator;
import org.glassfish.admin.amx.util.jmx.ObjectNameQuery;

public class ObjectNameQueryImpl
implements ObjectNameQuery {
    boolean match(Hashtable properties, Pattern propertyPattern, Pattern valuePattern) {
        EnumerationIterator keys = new EnumerationIterator(properties.keys());
        boolean matches = false;
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (propertyPattern != null && !propertyPattern.matcher(key).matches()) continue;
            if (valuePattern == null) {
                matches = true;
                break;
            }
            String value = (String)properties.get(key);
            if (!valuePattern.matcher(value).matches()) continue;
            matches = true;
            break;
        }
        return matches;
    }

    boolean matchAll(ObjectName name, Pattern[] propertyPatterns, Pattern[] valuePatterns) {
        boolean matches = true;
        Hashtable<String, String> properties = name.getKeyPropertyList();
        for (int i = 0; i < propertyPatterns.length; ++i) {
            if (this.match(properties, propertyPatterns[i], valuePatterns[i])) continue;
            matches = false;
            break;
        }
        return matches;
    }

    boolean matchAny(ObjectName name, Pattern[] propertyPatterns, Pattern[] valuePatterns) {
        boolean matches = false;
        Hashtable<String, String> properties = name.getKeyPropertyList();
        for (int i = 0; i < propertyPatterns.length; ++i) {
            if (!this.match(properties, propertyPatterns[i], valuePatterns[i])) continue;
            matches = true;
            break;
        }
        return matches;
    }

    Pattern[] createPatterns(String[] patternStrings, int numItems) {
        Pattern[] patterns = new Pattern[numItems];
        if (patternStrings == null) {
            for (int i = 0; i < numItems; ++i) {
                patterns[i] = null;
            }
            return patterns;
        }
        for (int i = 0; i < numItems; ++i) {
            patterns[i] = patternStrings[i] == null ? null : Pattern.compile(patternStrings[i]);
        }
        return patterns;
    }

    Set<ObjectName> matchEither(Matcher matcher, Set<ObjectName> startingSet, String[] regexNames, String[] regexValues) {
        if (regexNames == null && regexValues == null) {
            return startingSet;
        }
        HashSet<ObjectName> results = new HashSet<ObjectName>();
        int numMatches = 0;
        numMatches = regexNames != null ? regexNames.length : regexValues.length;
        Pattern[] namePatterns = this.createPatterns(regexNames, numMatches);
        Pattern[] valuePatterns = this.createPatterns(regexValues, numMatches);
        for (ObjectName name : startingSet) {
            if (!matcher.match(name, namePatterns, valuePatterns)) continue;
            results.add(name);
        }
        return results;
    }

    @Override
    public Set<ObjectName> matchAll(Set<ObjectName> startingSet, String[] regexNames, String[] regexValues) {
        return this.matchEither(new MatchAllMatcher(), startingSet, regexNames, regexValues);
    }

    @Override
    public Set<ObjectName> matchAny(Set<ObjectName> startingSet, String[] regexNames, String[] regexValues) {
        return this.matchEither(new MatchAnyMatcher(), startingSet, regexNames, regexValues);
    }

    private class MatchAllMatcher
    implements Matcher {
        @Override
        public boolean match(ObjectName name, Pattern[] names, Pattern[] values) {
            return ObjectNameQueryImpl.this.matchAll(name, names, values);
        }
    }

    private class MatchAnyMatcher
    implements Matcher {
        @Override
        public boolean match(ObjectName name, Pattern[] names, Pattern[] values) {
            return ObjectNameQueryImpl.this.matchAny(name, names, values);
        }
    }

    private static interface Matcher {
        public boolean match(ObjectName var1, Pattern[] var2, Pattern[] var3);
    }
}

