/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.transaction;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.ExceptionHandler;
import org.eclipse.persistence.exceptions.TransactionException;
import org.eclipse.persistence.internal.sequencing.SequencingCallback;
import org.eclipse.persistence.internal.sequencing.SequencingCallbackFactory;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.ExternalTransactionController;
import org.eclipse.persistence.sessions.broker.SessionBroker;
import org.eclipse.persistence.transaction.AbstractSynchronizationListener;
import org.eclipse.persistence.transaction.SynchronizationListenerFactory;

public abstract class AbstractTransactionController
implements ExternalTransactionController {
    protected ConcurrentMap unitsOfWork = new ConcurrentHashMap();
    protected AbstractSession session;
    protected SynchronizationListenerFactory listenerFactory;
    protected ThreadLocal activeUnitOfWorkThreadLocal = new ThreadLocal();
    protected ConcurrentMap<Object, AbstractSynchronizationListener> sequencingListeners;
    protected ConcurrentMap<Object, AbstractSynchronizationListener> currentlyProcessedListeners;
    protected int numSessionsRequiringSequencingCallback;
    protected ExceptionHandler exceptionHandler;

    @Override
    public ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    @Override
    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public void bindToCurrentTransaction(UnitOfWorkImpl unitOfWork, AbstractSession session) {
        Object status = this.getTransactionStatus();
        this.logTxStateTrace(unitOfWork, "TX_bind", status);
        try {
            Object txn = this.getTransaction();
            if (txn == null) {
                unitOfWork.beginTransaction();
                txn = this.getTransaction();
            }
            if (txn == null) {
                throw TransactionException.externalTransactionNotActive();
            }
            AbstractSynchronizationListener listener = this.getListenerFactory().newSynchronizationListener(unitOfWork, session, txn, this);
            this.registerSynchronization_impl(listener, txn);
            unitOfWork.setSynchronized(true);
        }
        catch (Exception exception) {
            throw TransactionException.errorBindingToExternalTransaction(exception);
        }
    }

    @Override
    public void beginTransaction(AbstractSession session) {
        try {
            Object status = this.getTransactionStatus();
            this.logTxStateTrace(session, "TX_begin", status);
            if (this.canBeginTransaction_impl(status)) {
                this.logTxTrace(session, "TX_beginningTxn", null);
                this.beginTransaction_impl();
                session.setWasJTSTransactionInternallyStarted(true);
            }
        }
        catch (Exception exception) {
            throw TransactionException.errorBeginningExternalTransaction(exception);
        }
    }

    @Override
    public void commitTransaction(AbstractSession session) {
        try {
            Object status = this.getTransactionStatus();
            this.logTxStateTrace(session, "TX_commit", status);
            if (this.canCommitTransaction_impl(status)) {
                this.logTxTrace(session, "TX_committingTxn", null);
                session.setWasJTSTransactionInternallyStarted(false);
                this.commitTransaction_impl();
            }
        }
        catch (Exception exception) {
            throw TransactionException.errorCommittingExternalTransaction(exception);
        }
    }

    @Override
    public void rollbackTransaction(AbstractSession session) {
        try {
            Object status = this.getTransactionStatus();
            this.logTxStateTrace(session, "TX_rollback", status);
            session.setWasJTSTransactionInternallyStarted(false);
            if (this.canRollbackTransaction_impl(status) && this.getTransaction() != null) {
                this.logTxTrace(session, "TX_rollingBackTxn", null);
                this.rollbackTransaction_impl();
            }
        }
        catch (Exception exception) {
            throw TransactionException.errorRollingBackExternalTransaction(exception);
        }
    }

    @Override
    public void markTransactionForRollback() {
        try {
            this.markTransactionForRollback_impl();
        }
        catch (Exception exception) {
            throw TransactionException.errorMarkingTransactionForRollback(exception);
        }
    }

    public Object getTransaction() {
        try {
            return this.getTransaction_impl();
        }
        catch (Exception exception) {
            throw TransactionException.errorGettingExternalTransaction(exception);
        }
    }

    public Object getTransactionKey(Object transaction) {
        try {
            return this.getTransactionKey_impl(transaction);
        }
        catch (Exception exception) {
            throw TransactionException.errorGettingExternalTransaction(exception);
        }
    }

    public Object getTransactionStatus() {
        try {
            return this.getTransactionStatus_impl();
        }
        catch (Exception exception) {
            throw TransactionException.errorGettingExternalTransactionStatus(exception);
        }
    }

    public boolean noTransactionOrRolledBackOrCommited() {
        try {
            Object status = this.getTransactionStatus();
            return this.canBeginTransaction_impl(status) || this.canMergeUnitOfWork_impl(status) || this.isRolledBack_impl(status);
        }
        catch (Exception exception) {
            throw TransactionException.errorGettingExternalTransactionStatus(exception);
        }
    }

    public abstract boolean isRolledBack_impl(Object var1);

    public boolean hasActiveUnitOfWork() {
        return this.lookupActiveUnitOfWork() != null;
    }

    @Override
    public UnitOfWorkImpl getActiveUnitOfWork() {
        Object transaction = this.getTransaction();
        if (transaction == null) {
            return null;
        }
        UnitOfWorkImpl activeUnitOfWork = this.lookupActiveUnitOfWork(transaction);
        if (activeUnitOfWork == null) {
            activeUnitOfWork = this.getSession().acquireUnitOfWork();
            Object transactionKey = this.getTransactionKey(transaction);
            this.addUnitOfWork(transactionKey, activeUnitOfWork);
            activeUnitOfWork.setTransaction(transaction);
            this.activeUnitOfWorkThreadLocal.set(activeUnitOfWork);
        }
        return activeUnitOfWork;
    }

    public UnitOfWorkImpl lookupActiveUnitOfWork() {
        return this.lookupActiveUnitOfWork(this.getTransaction());
    }

    public UnitOfWorkImpl lookupActiveUnitOfWork(Object transaction) {
        if (transaction == null) {
            return null;
        }
        Object transactionKey = this.getTransactionKey(transaction);
        UnitOfWorkImpl activeUnitOfWork = (UnitOfWorkImpl)this.activeUnitOfWorkThreadLocal.get();
        if (activeUnitOfWork != null && transaction == activeUnitOfWork.getTransaction()) {
            return activeUnitOfWork;
        }
        activeUnitOfWork = (UnitOfWorkImpl)this.getUnitsOfWork().get(transactionKey);
        if (activeUnitOfWork != null) {
            activeUnitOfWork.setTransaction(transaction);
        }
        this.activeUnitOfWorkThreadLocal.set(activeUnitOfWork);
        return activeUnitOfWork;
    }

    public void addUnitOfWork(Object transactionKey, UnitOfWorkImpl activeUnitOfWork) {
        this.activeUnitOfWorkThreadLocal.set(null);
        this.getUnitsOfWork().put(transactionKey, activeUnitOfWork);
    }

    public void removeUnitOfWork(Object transactionKey) {
        if (transactionKey != null) {
            this.getUnitsOfWork().remove(transactionKey);
        }
        this.activeUnitOfWorkThreadLocal.set(null);
    }

    @Override
    public AbstractSession getSession() {
        return this.session;
    }

    @Override
    public void setSession(AbstractSession session) {
        this.session = session;
        this.initializeSequencingListeners();
    }

    public Map getUnitsOfWork() {
        return this.unitsOfWork;
    }

    protected void setUnitsOfWork(ConcurrentMap unitsOfWork) {
        this.unitsOfWork = unitsOfWork;
    }

    public SynchronizationListenerFactory getListenerFactory() {
        return this.listenerFactory;
    }

    public void setListenerFactory(SynchronizationListenerFactory factory) {
        this.listenerFactory = factory;
    }

    @Override
    public void registerSynchronizationListener(UnitOfWorkImpl uow, AbstractSession session) throws DatabaseException {
        this.bindToCurrentTransaction(uow, session);
    }

    public Object jndiLookup(String jndiName) {
        InitialContext context = null;
        Object jndiObject = null;
        try {
            try {
                context = new InitialContext();
                jndiObject = context.lookup(jndiName);
            }
            catch (NamingException ex) {
                throw TransactionException.jndiLookupException(jndiName, ex);
            }
        }
        finally {
            if (context != null) {
                try {
                    context.close();
                }
                catch (Exception exception) {}
            }
        }
        return jndiObject;
    }

    @Override
    public void initializeSequencingListeners() {
        if (this.session == null) {
            return;
        }
        AbstractSession parentSession = this.session;
        while (parentSession.getParent() != null) {
            parentSession = parentSession.getParent();
        }
        int newNumSessionsRequiringSequencingCallback = 0;
        if (parentSession.isBroker()) {
            newNumSessionsRequiringSequencingCallback = ((SessionBroker)parentSession).howManySequencingCallbacks();
        } else if (((DatabaseSessionImpl)parentSession).isSequencingCallbackRequired()) {
            newNumSessionsRequiringSequencingCallback = 1;
        }
        if (newNumSessionsRequiringSequencingCallback > this.numSessionsRequiringSequencingCallback) {
            if (this.sequencingListeners == null) {
                this.sequencingListeners = new ConcurrentHashMap<Object, AbstractSynchronizationListener>();
            }
            if (this.currentlyProcessedListeners == null) {
                this.currentlyProcessedListeners = new ConcurrentHashMap<Object, AbstractSynchronizationListener>();
            }
            this.numSessionsRequiringSequencingCallback = newNumSessionsRequiringSequencingCallback;
        }
    }

    @Override
    public SequencingCallback getActiveSequencingCallback(DatabaseSession dbSession, SequencingCallbackFactory sequencingCallbackFactory) {
        Object transaction = this.getTransaction();
        if (transaction == null) {
            throw TransactionException.externalTransactionNotActive();
        }
        Object transactionKey = this.getTransactionKey(transaction);
        AbstractSynchronizationListener listener = (AbstractSynchronizationListener)this.sequencingListeners.get(transactionKey);
        if (listener == null) {
            listener = (AbstractSynchronizationListener)this.currentlyProcessedListeners.get(transactionKey);
            if (listener == null) {
                listener = this.getListenerFactory().newSynchronizationListener(null, null, transaction, this);
                try {
                    this.registerSynchronization_impl(listener, transaction);
                }
                catch (Exception exception) {
                    throw TransactionException.errorBindingToExternalTransaction(exception);
                }
            }
            this.sequencingListeners.put(transactionKey, listener);
        }
        return listener.getSequencingCallback(dbSession, sequencingCallbackFactory);
    }

    @Override
    public void clearSequencingListeners() {
        this.numSessionsRequiringSequencingCallback = 0;
        this.sequencingListeners = null;
        this.currentlyProcessedListeners = null;
    }

    public boolean isSequencingCallbackRequired() {
        return this.numSessionsRequiringSequencingCallback > 0;
    }

    public int numSessionsRequiringSequencingCallback() {
        return this.numSessionsRequiringSequencingCallback;
    }

    public void removeSequencingListener(Object transactionKey) {
        if (transactionKey != null) {
            this.sequencingListeners.remove(transactionKey);
        }
    }

    public void logTxTrace(AbstractSession session, String msgInd, Object[] args) {
        session.log(2, "transaction", msgInd, args);
    }

    public void logTxStateTrace(AbstractSession session, String msgInd, Object status) {
        if (session.shouldLog(2, "transaction")) {
            String statusString = this.statusToString_impl(status);
            Object[] args = new Object[]{statusString};
            session.log(2, "transaction", msgInd, args);
        }
    }

    protected abstract void registerSynchronization_impl(AbstractSynchronizationListener var1, Object var2) throws Exception;

    protected abstract Object getTransaction_impl() throws Exception;

    protected abstract Object getTransactionKey_impl(Object var1) throws Exception;

    protected abstract Object getTransactionStatus_impl() throws Exception;

    protected abstract void beginTransaction_impl() throws Exception;

    protected abstract void commitTransaction_impl() throws Exception;

    protected abstract void rollbackTransaction_impl() throws Exception;

    protected abstract void markTransactionForRollback_impl() throws Exception;

    protected abstract boolean canBeginTransaction_impl(Object var1);

    protected abstract boolean canCommitTransaction_impl(Object var1);

    protected abstract boolean canRollbackTransaction_impl(Object var1);

    protected abstract boolean canIssueSQLToDatabase_impl(Object var1);

    protected abstract boolean canMergeUnitOfWork_impl(Object var1);

    protected abstract String statusToString_impl(Object var1);
}

