/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.lib.harness;

import com.sun.ts.lib.util.ConfigUtil;
import com.sun.ts.lib.util.TestUtil;
import java.io.File;
import java.util.Properties;

public class RebuildableVerifier {
    public static final String REBUILDABLE_PROP_FILE_NAME = "rebuildable.properties";
    public static final String EXCLUDE_KEY = "exclude.dir";
    private static Properties mapping;
    private static String[] keys;
    private static String[] excludes;
    private String relativeTestDir;
    private static boolean loaded;
    private static RebuildableVerifier instance;

    private RebuildableVerifier() {
    }

    public static RebuildableVerifier getInstance(File path) {
        if (instance == null) {
            instance = new RebuildableVerifier();
        }
        instance.init(path);
        return instance;
    }

    private void loadExcludes() {
        excludes = mapping == null ? TestUtil.EMPTY_STRING_ARRAY : ConfigUtil.stringToArray((String)mapping.remove(EXCLUDE_KEY));
    }

    private void init(File file) {
        if (!loaded) {
            mapping = ConfigUtil.loadPropertiesFor(REBUILDABLE_PROP_FILE_NAME);
            this.loadExcludes();
            keys = ConfigUtil.loadKeysFrom(mapping);
            loaded = true;
        }
        if (mapping != null) {
            this.relativeTestDir = TestUtil.getRelativePath(file.getPath());
        }
    }

    private boolean isExcluded() {
        for (int i = 0; i < excludes.length; ++i) {
            if (!this.relativeTestDir.startsWith(excludes[i])) continue;
            TestUtil.logHarnessDebug("RebuildableVerifier:  This test dir is excluded from those listed in rebuildable.properties.");
            TestUtil.logHarnessDebug("RebuildableVerifier:  Please check your exclude list in the rebuildable.properties file.");
            return true;
        }
        return false;
    }

    public boolean isRebuildable() {
        boolean result = false;
        if (mapping == null || keys == null || this.isExcluded()) {
            result = false;
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                if (!("rebuildable." + this.relativeTestDir).startsWith(keys[i])) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    static {
        instance = new RebuildableVerifier();
    }
}

