/*
 * Copyright (c) 2017, 2020 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests._int.pattern.pattern_3;

import jakarta.xml.bind.*;
import javasoft.sqe.javatest.Status;
import java.io.PrintWriter;
import javasoft.sqe.tests.api.jakarta.xml.bind.CTTest;

public class pattern3_GetSetCTTests extends CTTest {

    /**
     * Command line starter.
     */
    public static void main(String[] args) {
        pattern3_GetSetCTTests test = new pattern3_GetSetCTTests();
        PrintWriter err = new PrintWriter(System.err, true);
        PrintWriter out = new PrintWriter(System.out, true);
        Status status = test.run(args, err, out);
        err.flush();
        out.flush();
        status.exit();
    }

    public Status GetSet001( ) {
        String[] xmlDocNames = {
            "pattern-3-1.xml", "pattern-3-2.xml", "pattern-3-3.xml",
            "pattern-3-4.xml", "pattern-3-5.xml"
        };
        int[] expectedValues = {-3, -1, -1, -3, -3};
        int[] anExpectedValues = {-1, -2, -4, -9, -3};
        
        for (int i = 0; i < xmlDocNames.length; ++i){
            JAXBElement<Integer> elemObj = (JAXBElement<Integer>)unmarshal(xmlDocNames[i]);
            if (elemObj.getValue() != expectedValues[i]){
                return Status.failed("used XML document: " + xmlDocNames[i] + ", elemObj.getValue() != " + expectedValues[i]);
            }
            elemObj.setValue(anExpectedValues[i]);
            if (elemObj.getValue() != anExpectedValues[i]){
                return Status.failed("used XML document: " + xmlDocNames[i] + ", elemObj.setValue(" + anExpectedValues[i] + 
                    ") invoked, " + "elemObj.getValue() != " + anExpectedValues[i]);
            }
        }
        return Status.passed("OKAY");
    }

    public Status GetSet002( ) {
        int[] setValues = {-3, -1, -1, -3, -3};
        int[] anSetValues = {-1, -2, -4, -9, -3};

        JAXBElement<Integer> elemObj = null;
        for (int i = 0; i < setValues.length; ++i){
            
                elemObj = (JAXBElement<Integer>)(new ObjectFactory()).createNISTSchemaIntPattern3(setValues[i]);
            
            if (elemObj.getValue() != setValues[i]){
                return Status.failed("dynamically created JAXBElement<Integer>, elemObj.getValue() != " + setValues[i]);
            }
            elemObj.setValue(anSetValues[i]);
            if (elemObj.getValue() != anSetValues[i]){
                return Status.failed("dynamically created JAXBElement<Integer>, elemObj.setValue(" + anSetValues[i] + 
                    ") invoked, " + "elemObj.getValue() != " + anSetValues[i]);
            }
        }
        return Status.passed("OKAY");
    }


}

