/*
 * Decompiled with CFR 0.152.
 */
package jdk.incubator.http;

import java.io.IOException;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.LinkedList;
import java.util.Objects;
import java.util.WeakHashMap;
import jdk.incubator.http.HeaderFilter;
import jdk.incubator.http.HeaderParser;
import jdk.incubator.http.HttpClientImpl;
import jdk.incubator.http.HttpHeaders;
import jdk.incubator.http.HttpRequestImpl;
import jdk.incubator.http.MultiExchange;
import jdk.incubator.http.Response;
import jdk.incubator.http.internal.common.Utils;

class AuthenticationFilter
implements HeaderFilter {
    volatile MultiExchange<?, ?> exchange;
    private static final Base64.Encoder encoder = Base64.getEncoder();
    static final int DEFAULT_RETRY_LIMIT = 3;
    static final int retry_limit = Utils.getIntegerNetProperty("jdk.httpclient.auth.retrylimit", 3);
    static final int UNAUTHORIZED = 401;
    static final int PROXY_UNAUTHORIZED = 407;
    static final WeakHashMap<HttpClientImpl, Cache> caches = new WeakHashMap();

    AuthenticationFilter() {
    }

    private PasswordAuthentication getCredentials(String string, boolean bl, HttpRequestImpl httpRequestImpl) throws IOException {
        HttpClientImpl httpClientImpl = this.exchange.client();
        Authenticator authenticator = httpClientImpl.authenticator().orElseThrow(() -> new IOException("No authenticator set"));
        URI uRI = httpRequestImpl.uri();
        HeaderParser headerParser = new HeaderParser(string);
        String string2 = headerParser.findKey(0);
        String string3 = headerParser.findValue("realm");
        Authenticator.RequestorType requestorType = bl ? Authenticator.RequestorType.PROXY : Authenticator.RequestorType.SERVER;
        return Authenticator.requestPasswordAuthentication(uRI.getHost(), null, uRI.getPort(), uRI.getScheme(), string3, string2, uRI.toURL(), requestorType);
    }

    private URI getProxyURI(HttpRequestImpl httpRequestImpl) {
        InetSocketAddress inetSocketAddress = httpRequestImpl.proxy(this.exchange.client());
        if (inetSocketAddress == null) {
            return null;
        }
        String string = "proxy." + httpRequestImpl.uri().getScheme();
        try {
            return new URI(string, null, inetSocketAddress.getHostString(), inetSocketAddress.getPort(), null, null, null);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new InternalError(uRISyntaxException);
        }
    }

    @Override
    public void request(HttpRequestImpl httpRequestImpl, MultiExchange<?, ?> multiExchange) throws IOException {
        CacheEntry cacheEntry;
        Object object;
        Cache cache = AuthenticationFilter.getCache(multiExchange);
        this.exchange = multiExchange;
        if (this.exchange.proxyauth == null && (object = this.getProxyURI(httpRequestImpl)) != null && (cacheEntry = cache.get((URI)object, true)) != null) {
            this.exchange.proxyauth = new AuthInfo(true, cacheEntry.scheme, null, cacheEntry);
            AuthenticationFilter.addBasicCredentials(httpRequestImpl, true, cacheEntry.value);
        }
        if (this.exchange.serverauth == null && (object = cache.get(httpRequestImpl.uri(), false)) != null) {
            this.exchange.serverauth = new AuthInfo(true, ((CacheEntry)object).scheme, null, (CacheEntry)object);
            AuthenticationFilter.addBasicCredentials(httpRequestImpl, false, ((CacheEntry)object).value);
        }
    }

    private static void addBasicCredentials(HttpRequestImpl httpRequestImpl, boolean bl, PasswordAuthentication passwordAuthentication) {
        String string = bl ? "Proxy-Authorization" : "Authorization";
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append(passwordAuthentication.getUserName()).append(':').append(passwordAuthentication.getPassword());
        String string2 = encoder.encodeToString(stringBuilder.toString().getBytes(StandardCharsets.ISO_8859_1));
        String string3 = "Basic " + string2;
        httpRequestImpl.setSystemHeader(string, string3);
    }

    @Override
    public HttpRequestImpl response(Response response) throws IOException {
        PasswordAuthentication passwordAuthentication;
        AuthInfo authInfo;
        Cache cache = AuthenticationFilter.getCache(this.exchange);
        int n = response.statusCode();
        HttpHeaders httpHeaders = response.headers();
        HttpRequestImpl httpRequestImpl = response.request();
        if (n != 401 && n != 407) {
            AuthInfo authInfo2;
            if (this.exchange.serverauth != null && !this.exchange.serverauth.fromcache) {
                authInfo2 = this.exchange.serverauth;
                cache.store(authInfo2.scheme, httpRequestImpl.uri(), false, authInfo2.credentials);
            }
            if (this.exchange.proxyauth != null && !this.exchange.proxyauth.fromcache) {
                authInfo2 = this.exchange.proxyauth;
                cache.store(authInfo2.scheme, httpRequestImpl.uri(), false, authInfo2.credentials);
            }
            return null;
        }
        boolean bl = n == 407;
        String string = bl ? "Proxy-Authenticate" : "WWW-Authenticate";
        String string2 = httpHeaders.firstValue(string).orElseThrow(() -> new IOException("Invalid auth header"));
        HeaderParser headerParser = new HeaderParser(string2);
        String string3 = headerParser.findKey(0);
        if (!string3.equalsIgnoreCase("Basic")) {
            return null;
        }
        String string4 = headerParser.findValue("realm");
        AuthInfo authInfo3 = authInfo = bl ? this.exchange.proxyauth : this.exchange.serverauth;
        if (authInfo == null) {
            PasswordAuthentication passwordAuthentication2 = this.getCredentials(string2, bl, httpRequestImpl);
            if (passwordAuthentication2 == null) {
                throw new IOException("No credentials provided");
            }
            authInfo = new AuthInfo(false, "Basic", passwordAuthentication2);
            if (bl) {
                this.exchange.proxyauth = authInfo;
            } else {
                this.exchange.serverauth = authInfo;
            }
            AuthenticationFilter.addBasicCredentials(httpRequestImpl, bl, passwordAuthentication2);
            return httpRequestImpl;
        }
        if (authInfo.retries > retry_limit) {
            throw new IOException("too many authentication attempts. Limit: " + Integer.toString(retry_limit));
        }
        if (authInfo.fromcache) {
            cache.remove(authInfo.cacheEntry);
        }
        if ((passwordAuthentication = this.getCredentials(string2, bl, httpRequestImpl)) == null) {
            throw new IOException("No credentials provided");
        }
        authInfo = authInfo.retryWithCredentials(passwordAuthentication);
        if (bl) {
            this.exchange.proxyauth = authInfo;
        } else {
            this.exchange.serverauth = authInfo;
        }
        AuthenticationFilter.addBasicCredentials(httpRequestImpl, bl, authInfo.credentials);
        ++authInfo.retries;
        return httpRequestImpl;
    }

    static synchronized Cache getCache(MultiExchange<?, ?> multiExchange) {
        HttpClientImpl httpClientImpl = multiExchange.client();
        Cache cache = caches.get(httpClientImpl);
        if (cache == null) {
            cache = new Cache();
            caches.put(httpClientImpl, cache);
        }
        return cache;
    }

    static class CacheEntry {
        final String root;
        final String scheme;
        final boolean proxy;
        final PasswordAuthentication value;

        CacheEntry(String string, URI uRI, boolean bl, PasswordAuthentication passwordAuthentication) {
            this.scheme = string;
            this.root = uRI.resolve(".").toString();
            this.proxy = bl;
            this.value = passwordAuthentication;
        }

        public PasswordAuthentication value() {
            return this.value;
        }

        public boolean equalsKey(URI uRI, boolean bl) {
            if (this.proxy != bl) {
                return false;
            }
            String string = uRI.toString();
            return string.startsWith(this.root);
        }
    }

    static class Cache {
        final LinkedList<CacheEntry> entries = new LinkedList();

        Cache() {
        }

        synchronized CacheEntry get(URI uRI, boolean bl) {
            for (CacheEntry cacheEntry : this.entries) {
                if (!cacheEntry.equalsKey(uRI, bl)) continue;
                return cacheEntry;
            }
            return null;
        }

        synchronized void remove(String string, URI uRI, boolean bl) {
            for (CacheEntry cacheEntry : this.entries) {
                if (!cacheEntry.equalsKey(uRI, bl)) continue;
                this.entries.remove(cacheEntry);
            }
        }

        synchronized void remove(CacheEntry cacheEntry) {
            this.entries.remove(cacheEntry);
        }

        synchronized void store(String string, URI uRI, boolean bl, PasswordAuthentication passwordAuthentication) {
            this.remove(string, uRI, bl);
            this.entries.add(new CacheEntry(string, uRI, bl, passwordAuthentication));
        }
    }

    static class AuthInfo {
        final boolean fromcache;
        final String scheme;
        int retries;
        PasswordAuthentication credentials;
        CacheEntry cacheEntry;

        AuthInfo(boolean bl, String string, PasswordAuthentication passwordAuthentication) {
            this.fromcache = bl;
            this.scheme = string;
            this.credentials = passwordAuthentication;
            this.retries = 1;
        }

        AuthInfo(boolean bl, String string, PasswordAuthentication passwordAuthentication, CacheEntry cacheEntry) {
            this(bl, string, passwordAuthentication);
            assert (passwordAuthentication == null || cacheEntry != null && cacheEntry.value == null);
            this.cacheEntry = cacheEntry;
        }

        AuthInfo retryWithCredentials(PasswordAuthentication passwordAuthentication) {
            AuthInfo authInfo = this.fromcache ? new AuthInfo(false, this.scheme, passwordAuthentication) : this;
            authInfo.credentials = Objects.requireNonNull(passwordAuthentication);
            authInfo.retries = this.retries;
            return authInfo;
        }
    }
}

