/*
 * Copyright (c) 2013, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.sun.ts.tests.concurrency.spec.ManagedThreadFactory.context_servlet;

import java.io.PrintWriter;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.annotation.WebServlet;
import com.sun.ts.tests.concurrency.api.common.*;
import javax.enterprise.concurrent.*;
import java.util.concurrent.*;
import javax.naming.*;
import com.sun.ts.lib.util.TestUtil;

public class TestServlet extends HttpServlet {

    private static final String TEST_JNDI_EVN_ENTRY_VALUE = "hello";
    private static final String TEST_JNDI_EVN_ENTRY_JNDI_NAME = "java:comp/env/ManagedThreadFactory_test_string";
    private static final String TEST_CLASSLOADER_CLASS_NAME = "com.sun.ts.tests.concurrency.spec.ManagedThreadFactory.context_servlet.TestServlet";
    
    public void doGet(HttpServletRequest req, HttpServletResponse res)
            throws ServletException, IOException {
        doPost(req, res);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res)
           throws ServletException, IOException {
        PrintWriter out = null;

        try {
            res.setContentType("text/plain");
            out = res.getWriter();

            InitialContext context = new InitialContext();
            ManagedThreadFactory factory = (ManagedThreadFactory) context
		    .lookup(Util.MANAGED_THREAD_FACTORY_SVC_JNDI_NAME);

            String opName = req.getParameter(Client.SERVLET_OP_ATTR_NAME);
            if (Client.SERVLET_OP_JNDICLASSLOADERPROPAGATIONTEST.equals(opName)) {
                CounterRunnableWithContext task = new CounterRunnableWithContext();
                Thread thread = factory.newThread(task);
                thread.start();
                Util.waitTillThreadFinish(thread);
                Util.assertEquals(1, task.getCount());
            } else {
            }

            out.println(Util.SERVLET_RETURN_SUCCESS);            
        } catch (Exception e) {
            if (out != null) {
                out.println(Util.SERVLET_RETURN_FAIL);
                out.println(e);
            }
        } finally { 
            if (null != out) {
                out.close();
            }
        }
    }

    public static class CounterRunnableWithContext extends RunnableTask{
        private volatile int count = 0;

        public int getCount(){
            return count;
        }

        public CounterRunnableWithContext(){
            super(TEST_JNDI_EVN_ENTRY_JNDI_NAME, TEST_JNDI_EVN_ENTRY_VALUE, TEST_CLASSLOADER_CLASS_NAME);
        }
        
        public void run(){
            super.run();
            count++;
        }
    }
}
