/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 *  $Id: JBIEETest.java 62564 2011-04-18 20:29:25Z kgrucci $
 */

package com.sun.ts.lib.tests.jbi;

/**
 * This class is a common test client for JBI tests 
 * which lookup a RemoteComponent.   
 */
import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest.Fault;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import java.util.Properties;
import com.sun.ts.lib.tests.jbi.RemoteComponentInterface;
import com.sun.ts.lib.tests.jbi.Result;
import com.sun.ts.lib.tests.jbi.ServiceRequest;
import com.sun.ts.lib.tests.jbi.RegistryUtils;
import com.sun.ts.lib.tests.jbi.Constants;

public abstract class JBIEETest extends EETest {
    protected Properties props;

    /* Run test */
    protected void commonMain(String[] args) {
	Status s = run(args, System.out, System.err);
	s.exit();
    }

    /*  Test setup: */
    public void setup(String[] args, Properties p) throws Fault {
	this.props = p;
	//	props.list(System.err);
    }

    protected RemoteComponentInterface getRemoteComponent() throws Exception {
	String rmiRegHost   = props.getProperty("jbi.rmi.host", "localhost");
	int    rmiRegPort   = Integer.parseInt(props.getProperty("jbi.rmi.port", "1099"));
        String rmiBoundname = getRMIBoundName();
 	TestUtil.logMsg("rmiRegHost   = " + rmiRegHost);
        TestUtil.logMsg("rmiRegPort   = " + rmiRegPort);
        TestUtil.logMsg("rmiBoundname = " + rmiBoundname);
        RemoteComponentInterface remoteBC = (RemoteComponentInterface)
	    RegistryUtils.lookup(rmiRegHost, rmiRegPort, rmiBoundname);
	return remoteBC;
    }

    protected abstract String getRMIBoundName();

    /* Run test */
    
    protected void runTest(String request) throws Fault {
	try {
	    RemoteComponentInterface rci = getRemoteComponent();
	    Result r = rci.invoke(new ServiceRequest(request, props));
	    System.err.println(r);
	    if (!r.passed()) {
		throw new Fault("Test Failed " + r.toString());
	    }
	} catch ( Exception e ) { 
	    throw new Fault("Test Failed!", e);
	}
    }

    /* cleanup -- none in this case */
    public void  cleanup() throws Fault	{		
	logMsg("Cleanup ok;");
    }
}
