/*
* Copyright (c) 2007, 2010, Oracle and/or its affiliates. All rights reserved.
* ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
*/

/*
 * $Id: LocalTxMessageListener.java 67292 2012-08-23 20:45:07Z phendley $
 */

package com.sun.ts.tests.common.connector.whitebox;

import javax.resource.spi.BootstrapContext;
import javax.resource.spi.work.WorkEvent;
import javax.resource.spi.work.WorkListener;
import javax.resource.spi.XATerminator;
import com.sun.ts.tests.common.connector.util.*;
import javax.transaction.xa.XAException;

public class LocalTxMessageListener implements WorkListener
{

    private XidImpl xid;
    private BootstrapContext bsc;

    public LocalTxMessageListener(XidImpl xid, BootstrapContext bsc)
    {
       this.xid = xid;
       this.bsc = bsc;
    }

    @Override
    public void workAccepted(WorkEvent e)
    {
       ConnectorStatus.getConnectorStatus().logState("LocalTxMessageListener.workAccepted");
       System.out.println("LocalTxMessageListener.workAccepted"); 
    }
    
    @Override
    public void workRejected(WorkEvent e)
    {
        ConnectorStatus.getConnectorStatus().logState("LocalTxMessageListener.workRejected");
        System.out.println("LocalTxMessageListener.workRejected"); 
    }
    
    @Override
    public void workStarted(WorkEvent e)
    {
        ConnectorStatus.getConnectorStatus().logState("LocalTxMessageListener.workStarted");
        System.out.println("LocalTxMessageListener.workStarted"); 
    }
    @Override
    public void workCompleted(WorkEvent e)
    {
       try
       {
          XATerminator xt = bsc.getXATerminator();
          xt.commit(this.xid, true);
          System.out.println("LocalTxMessageListener.workCompleted"); 
          System.out.println("XID getting used in XATerminator [ "+ xid.getFormatId() +" ]");
          ConnectorStatus.getConnectorStatus().logState("LocalTxMessageListener committed Xid");
       }
       catch (XAException ex)
       {
         ex.printStackTrace();
       }
    }

}
