/*
* Copyright (c) 2007, 2010, Oracle and/or its affiliates. All rights reserved.
* ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
*/

/*
 * $Id: TSDataSource.java 62543 2011-04-15 16:55:11Z phendley $
 */

package com.sun.ts.tests.common.connector.whitebox;

import java.util.Vector;

public interface TSDataSource extends TSConnectionFactory{

  /* @name     checkConnectionManager
   * @desc     return true if ConnectionManager is Serializable
   * @return   boolean
   */
   public boolean checkConnectionManager();

  /* @name     getLog
   * @desc     returns the Log.
   * @return   Log
   */
  public Vector getLog();

  /* @name     clearLog
   * @desc     Empties the Log
   */
  public void clearLog();

  /* @name     setLogFlag
   * @desc     Turns logging on/off
   */
  public void setLogFlag(boolean b);

  /* @name     getStateLog
   * @desc     returns the Log.
   * @return   Log
   */
  public Vector getStateLog();
  

}
