/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.matchingrules;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.matchingrules.MatchingRuleMessages;
import com.unboundid.ldap.matchingrules.SimpleMatchingRule;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class TelephoneNumberMatchingRule
extends SimpleMatchingRule {
    private static final TelephoneNumberMatchingRule INSTANCE = new TelephoneNumberMatchingRule();
    public static final String EQUALITY_RULE_NAME = "telephoneNumberMatch";
    static final String LOWER_EQUALITY_RULE_NAME = StaticUtils.toLowerCase("telephoneNumberMatch");
    public static final String EQUALITY_RULE_OID = "2.5.13.20";
    public static final String SUBSTRING_RULE_NAME = "telephoneNumberSubstringsMatch";
    static final String LOWER_SUBSTRING_RULE_NAME = StaticUtils.toLowerCase("telephoneNumberSubstringsMatch");
    public static final String SUBSTRING_RULE_OID = "2.5.13.21";
    private static final long serialVersionUID = -5463096544849211252L;

    public static TelephoneNumberMatchingRule getInstance() {
        return INSTANCE;
    }

    @Override
    public String getEqualityMatchingRuleName() {
        return EQUALITY_RULE_NAME;
    }

    @Override
    public String getEqualityMatchingRuleOID() {
        return EQUALITY_RULE_OID;
    }

    @Override
    public String getOrderingMatchingRuleName() {
        return null;
    }

    @Override
    public String getOrderingMatchingRuleOID() {
        return null;
    }

    @Override
    public String getSubstringMatchingRuleName() {
        return SUBSTRING_RULE_NAME;
    }

    @Override
    public String getSubstringMatchingRuleOID() {
        return SUBSTRING_RULE_OID;
    }

    @Override
    public int compareValues(ASN1OctetString value1, ASN1OctetString value2) throws LDAPException {
        throw new LDAPException(ResultCode.INAPPROPRIATE_MATCHING, MatchingRuleMessages.ERR_TELEPHONE_NUMBER_ORDERING_MATCHING_NOT_SUPPORTED.get());
    }

    @Override
    public ASN1OctetString normalize(ASN1OctetString value) throws LDAPException {
        byte[] valueBytes = value.getValue();
        StringBuilder buffer = new StringBuilder();
        block4: for (int i = 0; i < valueBytes.length; ++i) {
            switch (valueBytes[i]) {
                case 32: 
                case 45: {
                    continue block4;
                }
                case 39: 
                case 40: 
                case 41: 
                case 43: 
                case 44: 
                case 46: 
                case 47: 
                case 58: 
                case 61: 
                case 63: {
                    buffer.append((char)valueBytes[i]);
                    continue block4;
                }
                default: {
                    byte b = valueBytes[i];
                    if (b >= 48 && b <= 57 || b >= 97 && b <= 122 || b >= 65 && b <= 90) {
                        buffer.append((char)valueBytes[i]);
                        continue block4;
                    }
                    throw new LDAPException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, MatchingRuleMessages.ERR_TELEPHONE_NUMBER_INVALID_CHARACTER.get(i));
                }
            }
        }
        return new ASN1OctetString(buffer.toString());
    }

    @Override
    public ASN1OctetString normalizeSubstring(ASN1OctetString value, byte substringType) throws LDAPException {
        return this.normalize(value);
    }
}

