/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * @(#)BaseBootStrap.java	1.1 05/04/19
 */
package com.sun.ts.lib.tests.jbi;

import java.io.*;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import javax.management.MBeanServer;
import javax.jbi.JBIException;
import javax.jbi.component.InstallationContext;
import javax.jbi.management.MBeanNames;

public class RMIBootStrap extends BaseBootStrap {

    private ObjectName configMBeanName;
    private RMIMBean   configMBean;

    public RMIBootStrap() {
	NAME = getClass().getName();
    }
    
    public ObjectName getExtensionMBeanName() {
	super.getExtensionMBeanName();
	System.err.println("configMBeanName \"" + configMBeanName + "\"");
	return configMBeanName;
    }

    public void init(InstallationContext arg0) throws JBIException {
	super.init(arg0); // sets bictx in the parent
	if (bictx.isInstall()) {
	    registerConfigMBean();
	}
    }

    public void onInstall() throws JBIException {
	super.onInstall();
	try {
	    configMBean.saveProps(bictx.getContext());
	} catch (Exception e) {
	    e.printStackTrace();
	    throw new JBIException("RMIBootstrap.onInstall() Failed", e);
	}
    }

    public void onUninstall() throws JBIException {
	super.onUninstall();
    }

    public void cleanUp() throws JBIException {
	super.cleanUp();
	if (bictx.isInstall()) {
	    unregisterConfigMBean();
	}
    }

    /*
     * Code to register/unregister the config MBean used to store props passed from
     * jbi-install-component task.  Thes props are stored in a serialized properties
     * file so the binding component can use them to configure itself.
     */

    // can be overridden by sub classes to specify a different flavor of RMIMBean.
    // Currently we have two flavors, one that writes the specified param values
    // to a props file on disk and one that writes the specified param values
    // to the JNDI naming context.  The default is to write the props to the
    // naming context, see RMIMBeanImpl for default code and the sub class
    // RMIMBeanPropFileImpl for the other flavor (simply overrides saveProps).

    protected RMIMBean getMBeanImpl() {
	return new RMIMBeanImpl();
    }

    protected StandardMBean initMBean() throws JBIException {
	StandardMBean mbean = null;
	try {
            if (configMBean == null) {
                configMBean = getMBeanImpl();
            }
            if (configMBeanName == null) {
                MBeanNames mbnHndl = bictx.getContext().getMBeanNames();
                configMBeanName = mbnHndl.createCustomComponentMBeanName(bictx.getComponentName());
            }
	    mbean = new StandardMBean(configMBean, com.sun.ts.lib.tests.jbi.RMIMBean.class);
	    System.err.println("initMBean() " + configMBeanName);
        } catch (Exception e) {
            e.printStackTrace();
            throw new JBIException("initMBean() Failed", e);
        }
	return mbean;
    }
    
    protected void unregisterConfigMBean() throws JBIException {
        try {
            MBeanServer mbServer = bictx.getContext().getMBeanServer();
            mbServer.unregisterMBean(configMBeanName);
            configMBeanName = null;
            configMBean = null;
	    System.err.println("unregisterConfigMBean() " + configMBeanName);
        } catch (Exception e) {
            e.printStackTrace();
            throw new JBIException("unregisterConfigMBean() Failed", e);
        }
    }

    protected void registerConfigMBean() throws JBIException {
	MBeanServer mbServer = bictx.getContext().getMBeanServer();
        try {
	    StandardMBean mbean = initMBean();
            mbServer.registerMBean(mbean, configMBeanName);
	    System.err.println("registerConfigMBean() " + configMBeanName);
        } catch (Exception e) {
            e.printStackTrace();
	    throw new JBIException(e);
        }
    }

}
