/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: BaseCalculator.java 62595 2011-04-20 20:38:55Z kgrucci $
 */

package com.sun.ts.tests.ejb30.common.calc;

/**
 * An implementation class of <code>Calculator</code> interface. It forwards
 * to an instance of <code>NoInterfaceCalculator</code> for all operations.
 * 
 * @author Cheng Fang
 */
public class BaseCalculator implements Calculator {

    private NoInterfaceCalculator calc = new NoInterfaceCalculator();

    /** Creates a new instance of BaseCalculator */
    public BaseCalculator() {
    }

    public int subtract(int a, int b) {
        return calc.subtract(a, b);
    }

    public int add(int a, int b) {
        return calc.add(a, b);
    }

    /*
     * Tests that the methods in business interface may throw arbitrary
     * application exceptions.
     * 
     * @see com.sun.ts.tests.ejb30.common.calc.Calculator#throwIt()
     */
    public void throwIt() throws CalculatorException {
        calc.throwIt();
    }
}
