/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.interview;

import com.sun.interview.ChoiceQuestion;
import com.sun.interview.FinalQuestion;
import com.sun.interview.Interview;
import com.sun.interview.Question;
import com.sun.interview.StringQuestion;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.interview.BasicInterviewParameters;
import com.sun.javatest.interview.TestsInterview;
import com.sun.jck.interview.CompilerInterview;
import com.sun.jck.interview.DevtoolsInterview;
import com.sun.jck.interview.JCKEnvInterview;
import com.sun.jck.interview.JCKParameters;
import com.sun.jck.interview.RuntimeInterview;
import com.sun.jck.interview.TestPlatformInterview;
import java.io.File;
import java.util.Map;

public class EnvironmentInterview
extends JCKEnvInterview {
    static final String COMPILER = "compiler";
    static final String RUNTIME = "runtime";
    static final String DEVTOOLS = "devtools";
    private ChoiceQuestion qProduct = new ChoiceQuestion(this, "product"){
        {
            this.setChoices(new String[]{null, EnvironmentInterview.RUNTIME, EnvironmentInterview.COMPILER, EnvironmentInterview.DEVTOOLS});
        }

        public boolean isHidden() {
            return !EnvironmentInterview.this.qProductEditable;
        }

        public void export(Map map) {
            String string = "";
            if (this.value == EnvironmentInterview.RUNTIME) {
                string = " -runtime";
            } else if (this.value == EnvironmentInterview.COMPILER) {
                string = " -compiler";
            } else if (this.value == EnvironmentInterview.DEVTOOLS) {
                string = " -devtools";
            }
            map.put("testsuite", "com.sun.jck.lib.JCKTestSuite " + string);
            map.put("script", "com.sun.jck.lib.JCKScript " + string);
            map.put("finder", "com.sun.jck.lib.JCKTestFinder");
        }

        public void setValue(String string) {
            if (EnvironmentInterview.this.qProductEditable) {
                super.setValue(string);
            }
        }

        public void clear() {
            if (EnvironmentInterview.this.qProductEditable) {
                super.clear();
            }
        }

        protected void load(Map map) {
            if (EnvironmentInterview.this.qProductEditable) {
                super.load(map);
            }
        }

        protected Question getNext() {
            if (this.isHidden() || this.value != null) {
                return EnvironmentInterview.this.qSimpleOrAdvanced;
            }
            return null;
        }
    };
    boolean qProductEditable = true;
    static final String SIMPLE_MODE = "simple";
    static final String SIMPLE_TO_SIMPLE = "continue in Simple Mode ";
    static final String SIMPLE_TO_ADVANCED = "switch to Advanced Mode";
    static final String[] SIMPLE_DISPLAY_CHOISES;
    static final String ADVANCED_MODE = "advanced";
    static final String ADVANCED_TO_ADVANCED = "continue in Advanced Mode";
    static final String ADVANCED_TO_SIMPLE = "switch to Simple Mode";
    static final String[] ADVANCED_DISPLAY_CHOISES;
    static final String[] SIMPLE_ADVANCED_CHOISES;
    static final String[] ADVANCED_SIMPLE_CHOISES;
    private ChoiceQuestion qSimpleOrAdvanced = new ChoiceQuestion(this, "simpleOrAdvanced"){
        String simpleText;
        {
            this.setChoices(SIMPLE_ADVANCED_CHOISES, SIMPLE_DISPLAY_CHOISES);
            this.setValue(EnvironmentInterview.SIMPLE_MODE);
        }

        public String getText() {
            if (this.value == EnvironmentInterview.SIMPLE_MODE) {
                if (this.simpleText == null) {
                    this.simpleText = this.getResourceString("EnvironmentInterview.simpleOrAdvanced.text2", true);
                }
                return this.simpleText;
            }
            return super.getText();
        }

        protected Question getNext() {
            if (this.value == EnvironmentInterview.ADVANCED_MODE) {
                this.setChoices(ADVANCED_SIMPLE_CHOISES, ADVANCED_DISPLAY_CHOISES);
                return EnvironmentInterview.this.qEnvName;
            }
            if (this.value == EnvironmentInterview.SIMPLE_MODE) {
                this.setChoices(SIMPLE_ADVANCED_CHOISES, SIMPLE_DISPLAY_CHOISES);
                return EnvironmentInterview.this.qEnvName;
            }
            return null;
        }
    };
    private StringQuestion qEnvName = new StringQuestion(this, "envName"){
        private boolean valid;

        private boolean isValidIdentifier(String string) {
            if (string == null || string.equals("")) {
                return false;
            }
            if (!Character.isUnicodeIdentifierStart(string.charAt(0))) {
                return false;
            }
            for (int i = 1; i < string.length(); ++i) {
                if (Character.isUnicodeIdentifierPart(string.charAt(i))) continue;
                return false;
            }
            return true;
        }

        public void setValue(String string) {
            this.valid = this.isValidIdentifier(string);
            super.setValue(string);
        }

        protected Question getNext() {
            if (this.valid) {
                return EnvironmentInterview.this.qDescription;
            }
            return null;
        }

        public boolean isHidden() {
            if (super.isHidden()) {
                return true;
            }
            boolean bl = EnvironmentInterview.this.isSimple();
            if (bl) {
                this.setValue(this.getDefValue());
            }
            return bl;
        }

        public String[] getSuggestions() {
            return new String[]{this.getDefValue()};
        }

        private String getDefValue() {
            String string = EnvironmentInterview.this.qProduct.getValue();
            String string2 = "jck_" + string;
            String string3 = System.getProperty("os.name");
            if (string3 != null && string3.length() > 0 && !this.isValidIdentifier(string3)) {
                string3 = string3.replace(' ', '_');
            }
            if (this.isValidIdentifier(string3)) {
                string2 = string2 + "_" + string3.toLowerCase();
            }
            return string2;
        }
    };
    private Question qDescription = new StringQuestion(this, "description"){

        protected void export(Map map) {
            map.put("description", this.value);
        }

        protected Question getNext() {
            String string;
            if (this.value == null) {
                return null;
            }
            Interview interview = EnvironmentInterview.this.isRuntime() ? EnvironmentInterview.this.iRuntime : (EnvironmentInterview.this.isCompiler() ? EnvironmentInterview.this.iCompiler : EnvironmentInterview.this.iDevtools);
            TestsInterview testsInterview = (TestsInterview)EnvironmentInterview.this.getRootInterview().getTestsParameters();
            BasicInterviewParameters basicInterviewParameters = (BasicInterviewParameters)testsInterview.getParent();
            if (basicInterviewParameters.getWorkDirectory() == null && (string = System.getProperty("EnvironmentInterview.workDir")) != null) {
                try {
                    basicInterviewParameters.setWorkDirectory(WorkDirectory.open(new File(string)));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return EnvironmentInterview.this.callInterview(testsInterview, EnvironmentInterview.this.callInterview(EnvironmentInterview.this.iTestPlatform, EnvironmentInterview.this.callInterview(interview, EnvironmentInterview.this.qEnd)));
        }

        public boolean isHidden() {
            if (super.isHidden()) {
                return true;
            }
            boolean bl = EnvironmentInterview.this.isSimple();
            if (bl) {
                this.setValue(this.getDefValue());
            }
            return bl;
        }

        public String[] getSuggestions() {
            return new String[]{this.getDefValue()};
        }

        private String getDefValue() {
            return "";
        }
    };
    static final String SOLARIS = "Solaris";
    static final String LINUX = "Linux";
    static final String LOCAL = "Current system";
    static final String WINDOWS = "Windows";
    static final String OTHER = "other";
    static final String[] allOSChoices;
    static final String[] stdOSChoices;
    static final String localOSName;
    private int mode;
    private final JCKParameters parent;
    private final TestPlatformInterview iTestPlatform = new TestPlatformInterview(this);
    private final Interview iRuntime = new RuntimeInterview(this);
    private final Interview iCompiler = new CompilerInterview(this);
    private final Interview iDevtools = new DevtoolsInterview(this);
    private final Question qEnd = new FinalQuestion(this);

    public EnvironmentInterview(JCKParameters jCKParameters) {
        super(jCKParameters, "env");
        this.parent = jCKParameters;
        this.setFirstQuestion(this.qProduct);
    }

    TestPlatformInterview getTestPlatformInterview() {
        return this.iTestPlatform;
    }

    String getName() {
        return this.qEnvName.getValue();
    }

    void setName(String string) {
        this.qEnvName.setValue(string);
    }

    void setProduct(String string) {
        boolean bl = this.qProductEditable;
        if (string == null) {
            this.qProductEditable = true;
            this.qProduct.clear();
        } else if (string.equals(COMPILER) || string.equals(RUNTIME) || string.equals(DEVTOOLS)) {
            this.qProductEditable = true;
            this.qProduct.setValue(string);
            this.qProductEditable = false;
        } else {
            throw new IllegalArgumentException();
        }
        if (this.qProductEditable != bl) {
            this.updatePath();
        }
    }

    void setMode(int n) {
        this.mode = n;
        if (this.isRuntime()) {
            ((RuntimeInterview)this.iRuntime).setMode(n);
            ((RuntimeInterview)this.iRuntime).setFirstQuestion();
        }
    }

    JCKParameters getRootInterview() {
        return this.parent;
    }

    public void export(Map map) {
        super.export(map);
        this.getTestPlatformInterview().export(map);
        Interview interview = this.isRuntime() ? this.iRuntime : (this.isCompiler() ? this.iCompiler : this.iDevtools);
        interview.export(map);
    }

    boolean isRuntime() {
        return this.qProduct.getValue() == RUNTIME;
    }

    boolean isCompiler() {
        return this.qProduct.getValue() == COMPILER;
    }

    boolean isDevtools() {
        return this.qProduct.getValue() == DEVTOOLS;
    }

    boolean isSimple() {
        return this.qSimpleOrAdvanced.getValue() == SIMPLE_MODE;
    }

    static char getFileSep(String string) {
        if (LOCAL.equals(string)) {
            return File.separatorChar;
        }
        if (EnvironmentInterview.isWindows(string)) {
            return '\\';
        }
        return '/';
    }

    static char getPathSep(String string) {
        if (LOCAL.equals(string)) {
            return File.pathSeparatorChar;
        }
        if (EnvironmentInterview.isWindows(string)) {
            return ';';
        }
        return ':';
    }

    static boolean isWindows(String string) {
        if (string == null) {
            return false;
        }
        if (string.equals(LOCAL)) {
            if (localOSName == null) {
                return false;
            }
            string = localOSName;
        }
        return string.startsWith(WINDOWS);
    }

    static boolean isUnixlike(String string) {
        if (string == null) {
            return false;
        }
        if (string.equals(LOCAL)) {
            if (localOSName == null) {
                return false;
            }
            string = localOSName;
        }
        return string.startsWith(SOLARIS) || string.startsWith(LINUX);
    }

    static {
        block3: {
            SIMPLE_DISPLAY_CHOISES = new String[]{SIMPLE_TO_SIMPLE, SIMPLE_TO_ADVANCED};
            ADVANCED_DISPLAY_CHOISES = new String[]{ADVANCED_TO_ADVANCED, ADVANCED_TO_SIMPLE};
            SIMPLE_ADVANCED_CHOISES = new String[]{SIMPLE_MODE, ADVANCED_MODE};
            ADVANCED_SIMPLE_CHOISES = new String[]{ADVANCED_MODE, SIMPLE_MODE};
            allOSChoices = new String[]{null, LOCAL, SOLARIS, LINUX, WINDOWS, OTHER};
            stdOSChoices = new String[]{SOLARIS, LINUX, WINDOWS};
            String string = System.getProperty("os.name");
            if (string != null && string.equals("SunOS")) {
                localOSName = SOLARIS;
            } else {
                for (int i = 0; i < stdOSChoices.length; ++i) {
                    if (string == null || !string.startsWith(stdOSChoices[i])) continue;
                    localOSName = string;
                    break block3;
                }
                localOSName = null;
            }
        }
    }
}

