/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.interview;

import com.sun.interview.FinalQuestion;
import com.sun.interview.Question;
import com.sun.jck.interview.JCKEnvInterview;
import com.sun.jck.interview.JCKExportedQuestion;
import com.sun.jck.interview.JCKParameters;
import com.sun.jck.interview.JCKStringQuestion;
import com.sun.jck.interview.JCKYesNoQuestion;
import com.sun.jck.interview.RuntimeInterview;
import com.sun.jck.interview.SwitchInterviewQuestion;
import com.sun.jck.interview.TestPlatformInterview;
import com.sun.jck.interview.Utils;
import java.util.Map;

class RuntimeAWTInterview
extends JCKEnvInterview {
    private JCKYesNoQuestion qRobotAvailable = new JCKYesNoQuestion(this, "robotAvailable"){

        public void export(Map map) {
            boolean bl = this.value == "Yes";
            map.put("robotAvailable", String.valueOf(bl));
            map.put("context.robotAvailable", String.valueOf(bl));
            map.put("platform.robotAvailable", String.valueOf(bl));
        }

        protected Question getNext() {
            if (this.value == null) {
                return null;
            }
            return RuntimeAWTInterview.this.qCrossWindowFocusTransferSupported;
        }

        public boolean isHidden() {
            TestPlatformInterview testPlatformInterview = RuntimeAWTInterview.this.getTestPlatformInterview();
            if (testPlatformInterview.isHeadless()) {
                return true;
            }
            boolean bl = RuntimeAWTInterview.this.parent.isSimple();
            if (bl) {
                this.setValue(this.getDefValue());
            }
            return bl;
        }

        private String getDefValue() {
            return "Yes";
        }
    };
    private JCKYesNoQuestion qCrossWindowFocusTransferSupported = new JCKYesNoQuestion(this, "crossWindowFocusTransferSupported"){

        public void export(Map map) {
            boolean bl = this.value == "Yes";
            map.put("crossWindowFocusTransferSupported", String.valueOf(bl));
            map.put("context.crossWindowFocusTransferSupported", String.valueOf(bl));
            map.put("platform.crossWindowFocusTransferSupported", String.valueOf(bl));
        }

        protected Question getNext() {
            if (this.value == null) {
                return null;
            }
            return RuntimeAWTInterview.this.qSplashScreenSupported;
        }

        public boolean isHidden() {
            TestPlatformInterview testPlatformInterview = RuntimeAWTInterview.this.getTestPlatformInterview();
            if (testPlatformInterview.isHeadless()) {
                return true;
            }
            boolean bl = RuntimeAWTInterview.this.parent.isSimple();
            if (bl) {
                this.setValue(this.getDefValue());
            }
            return bl;
        }

        private String getDefValue() {
            return "Yes";
        }
    };
    private TestArgsQuestion qSplashScreenSupported = new TestArgsQuestion("splashScreenSupported"){

        public boolean isHidden() {
            if (!RuntimeAWTInterview.this.getTestPlatformInterview().isMultiJVM()) {
                this.setValue("No");
                return true;
            }
            boolean bl = this.matchTests();
            if (bl && !RuntimeAWTInterview.this.parent.isSimple()) {
                return false;
            }
            this.setValue(this.getDefValue());
            return true;
        }

        String[] getTestURL() {
            return new String[]{"api/java_awt/SplashScreen"};
        }

        protected Question getNext() {
            if (this.value == null) {
                return null;
            }
            if (this.value == "Yes") {
                return RuntimeAWTInterview.this.qSplashScreenOpt;
            }
            return RuntimeAWTInterview.this.qEnd;
        }

        public void export(Map map) {
            boolean bl = this.value == "Yes";
            map.put("platform.splashScreenSupported", String.valueOf(bl));
        }

        private String getDefValue() {
            return "Yes";
        }
    };
    private JCKStringQuestion qSplashScreenOpt = new JCKStringQuestion(this, "splashScreenOpt"){
        private final String DEFAULT = "-splash:#";
        {
            this.DEFAULT = "-splash:#";
            this.setSuggestions(new String[]{"", "-splash:#"});
            this.setDefaultValue("-splash:#");
        }

        public boolean isHidden() {
            boolean bl = RuntimeAWTInterview.this.qSplashScreenSupported.isHidden();
            if (bl) {
                this.setValue(this.getDefValue());
            }
            return bl;
        }

        protected Question getNext() {
            if (this.value == null || this.value.trim().length() == 0 || this.value.indexOf("#") == -1) {
                return null;
            }
            return RuntimeAWTInterview.this.qEnd;
        }

        public void export(Map map) {
            map.put("platform.splashScreenOption", Utils.evalTemplate(this.value, "${jvmArgSplashValue}"));
        }

        private String getDefValue() {
            return "-splash:#";
        }
    };
    private Question qEnd = new FinalQuestion(this);
    private RuntimeInterview parent;

    RuntimeAWTInterview(RuntimeInterview runtimeInterview) {
        super(runtimeInterview, "awt");
        this.parent = runtimeInterview;
        this.setFirstQuestion(this.qRobotAvailable);
    }

    public void export(Map map) {
        super.export(map);
        if (this.parent.isSimple()) {
            JCKExportedQuestion[] jCKExportedQuestionArray = new JCKExportedQuestion[]{this.qRobotAvailable, this.qCrossWindowFocusTransferSupported, this.qSplashScreenSupported, this.qSplashScreenOpt};
            for (int i = 0; i < jCKExportedQuestionArray.length; ++i) {
                JCKExportedQuestion jCKExportedQuestion = jCKExportedQuestionArray[i];
                if (!jCKExportedQuestion.isHidden()) continue;
                jCKExportedQuestion.export(map);
            }
        }
    }

    void exportForAdvancedMode(Map map) {
        this.qSplashScreenSupported.export(map);
    }

    private TestPlatformInterview getTestPlatformInterview() {
        return this.parent.getTestPlatformInterview();
    }

    private abstract class TestArgsQuestion
    extends SwitchInterviewQuestion
    implements JCKExportedQuestion {
        TestArgsQuestion(String string) {
            super(RuntimeAWTInterview.this, string);
        }

        public void export(Map map) {
            super.export(map);
        }

        JCKParameters getJCKParametersInterview() {
            return RuntimeAWTInterview.this.parent.getRootInterview();
        }
    }
}

