/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.interview;

import com.sun.interview.ErrorQuestion;
import com.sun.interview.FileQuestion;
import com.sun.interview.FinalQuestion;
import com.sun.interview.Interview;
import com.sun.interview.NullQuestion;
import com.sun.interview.Question;
import com.sun.javatest.TestSuite;
import com.sun.jck.interview.AgentInterview;
import com.sun.jck.interview.EnvironmentInterview;
import com.sun.jck.interview.JCKParameters;
import com.sun.jck.interview.JCKYesNoQuestion;
import com.sun.jck.interview.ProductInterview;
import com.sun.jck.interview.RuntimeAWTInterview;
import com.sun.jck.interview.RuntimeAudioInterview;
import com.sun.jck.interview.RuntimeFPInterview;
import com.sun.jck.interview.RuntimeIDLInterview;
import com.sun.jck.interview.RuntimeJAASInterview;
import com.sun.jck.interview.RuntimeJDWPInterview;
import com.sun.jck.interview.RuntimeJGSSInterview;
import com.sun.jck.interview.RuntimeJPLISInterview;
import com.sun.jck.interview.RuntimeJSSEInterview;
import com.sun.jck.interview.RuntimeMemoryInterview;
import com.sun.jck.interview.RuntimeNetworkInterview;
import com.sun.jck.interview.RuntimePrintInterview;
import com.sun.jck.interview.RuntimeRemoteAgentInterview;
import com.sun.jck.interview.RuntimeStaticSigTestInterview;
import com.sun.jck.interview.RuntimeTcpPortRangeInterview;
import com.sun.jck.interview.RuntimeTestExecuteInterview;
import com.sun.jck.interview.RuntimeURLInterview;
import com.sun.jck.interview.ServicesInterview;
import com.sun.jck.interview.SwitchInterviewQuestion;
import com.sun.jck.interview.TestPlatformInterview;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;

class RuntimeInterview
extends ProductInterview {
    private Question qRefCompileFile = new FileQuestion(this, "refCompileFile"){
        FileInputStream fis;
        Properties props;
        String s;
        boolean fileNotFound;
        boolean fileError;
        {
            this.fis = null;
            this.props = null;
        }

        protected Question getNext() {
            this.fileNotFound = false;
            this.fileError = false;
            if (this.value == null || this.value.getPath().length() == 0) {
                return null;
            }
            try {
                this.fis = new FileInputStream(this.value);
                this.props = new Properties();
                this.props.load(this.fis);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.fileNotFound = true;
            }
            catch (IOException iOException) {
                this.fileError = true;
            }
            if (this.fileNotFound || this.fileError) {
                return RuntimeInterview.this.qRefCompileFileError;
            }
            if (RuntimeInterview.this.getMode() == 2) {
                return RuntimeInterview.this.qEnd;
            }
            return RuntimeInterview.this.qIntro;
        }

        public void export(Map map) {
            if (this.value != null) {
                Enumeration<?> enumeration = this.props.propertyNames();
                while (enumeration.hasMoreElements()) {
                    this.s = enumeration.nextElement().toString();
                    map.put(this.s, this.props.getProperty(this.s));
                }
            }
            if (this.props != null) {
                RuntimeInterview.this.precompileDir = this.props.getProperty("testClassDir");
            }
        }
    };
    private ErrorQuestion qRefCompileFileError = new ErrorQuestion(this, "refCompileFileError");
    private Question qIntro = new NullQuestion(this, "intro"){

        protected Question getNext() {
            return RuntimeInterview.this.qServices;
        }

        public boolean isHidden() {
            return RuntimeInterview.this.parent.isSimple();
        }
    };
    private Question qServices = new NullQuestion(this, "services"){

        protected Question getNext() {
            TestPlatformInterview testPlatformInterview = RuntimeInterview.this.parent.getTestPlatformInterview();
            Question question = testPlatformInterview.isMultiJVM() ? (testPlatformInterview.isUseAgent() ? RuntimeInterview.this.qAgentOtherJVM : RuntimeInterview.this.qOtherJVM) : RuntimeInterview.this.qAgentSameJVM;
            return RuntimeInterview.this.callInterview(RuntimeInterview.this.iServices, question);
        }

        public boolean isHidden() {
            return true;
        }
    };
    private Question qAgentSameJVM = new NullQuestion(this, "agentSameJVM"){

        protected Question getNext() {
            return RuntimeInterview.this.callInterview(RuntimeInterview.this.iAgent, RuntimeInterview.this.callRuntimeTestExecute());
        }
    };
    private final Question qAgentOtherJVM = new NullQuestion(this, "agentOtherJVM"){

        protected Question getNext() {
            return RuntimeInterview.this.callInterview(RuntimeInterview.this.iAgent, RuntimeInterview.this.callRuntimeTestExecute());
        }
    };
    private Question qOtherJVM = new NullQuestion(this, "otherJVM"){

        protected Question getNext() {
            return RuntimeInterview.this.callRuntimeTestExecute();
        }

        public boolean isHidden() {
            return RuntimeInterview.this.parent.isSimple();
        }
    };
    private Question qTestArgs = new NullQuestion(this, "testArgs"){

        protected Question getNext() {
            return RuntimeInterview.this.qFP;
        }
    };
    private Question qFP = new TestArgsQuestion("fp"){

        protected Question getNext() {
            return this.getNext(RuntimeInterview.this.iRuntimeFP, RuntimeInterview.this.qAudio);
        }

        String[] getTestURL() {
            return new String[]{"lang/FP", "vm/fp"};
        }
    };
    private Question qAudio = new TestArgsQuestion("audio"){

        protected Question getNext() {
            return this.getNext(RuntimeInterview.this.iRuntimeAudio, RuntimeInterview.this.qJAAS);
        }

        String[] getTestURL() {
            return new String[]{"api/javax_sound"};
        }
    };
    private Question qJAAS = new TestArgsQuestion("jaas"){

        protected Question getNext() {
            return this.getNext(RuntimeInterview.this.iRuntimeJAAS, RuntimeInterview.this.qJGSS);
        }

        String[] getTestURL() {
            return new String[]{"api/javax_security", "api/org_ietf"};
        }
    };
    private Question qJGSS = new TestArgsQuestion("jgss"){

        protected Question getNext() {
            return this.getNext(RuntimeInterview.this.iRuntimeJGSS, RuntimeInterview.this.qMemory);
        }

        String[] getTestURL() {
            return new String[]{"api/javax_security", "api/org_ietf"};
        }
    };
    private Question qMemory = new TestArgsQuestion("memory"){

        protected Question getNext() {
            return this.getNext(RuntimeInterview.this.iRuntimeMemory, RuntimeInterview.this.qTCPRange);
        }

        String[] getTestURL() {
            return new String[]{"vm/concepts", "lang/EXCP", "lang/EXPR", "lang/EXEC"};
        }
    };
    private JCKYesNoQuestion qTCPRange = new JCKYesNoQuestion(this, "tcpRange"){

        public void export(Map map) {
            String string = this.value == "Yes" ? ((RuntimeInterview)RuntimeInterview.this).iRuntimeTcpPortRange.qTCPLower.getValue() + "-" + ((RuntimeInterview)RuntimeInterview.this).iRuntimeTcpPortRange.qTCPUpper.getValue() : "0";
            map.put("network.tcpPortRange", string);
        }

        protected Question getNext() {
            Question question = RuntimeInterview.this.qNetwork;
            if (this.value == "Yes") {
                return RuntimeInterview.this.callInterview(RuntimeInterview.this.iRuntimeTcpPortRange, question);
            }
            if (this.value == "No") {
                return question;
            }
            return null;
        }

        public boolean isHidden() {
            boolean bl = RuntimeInterview.this.parent.isSimple();
            if (bl) {
                this.setValue(this.getDefValue());
            }
            return bl;
        }

        private String getDefValue() {
            return "No";
        }
    };
    private Question qNetwork = new TestArgsQuestion("net"){

        protected Question getNext() {
            return this.getNext(RuntimeInterview.this.iRuntimeNetwork, RuntimeInterview.this.qRemoteAgent);
        }

        String[] getTestURL() {
            return new String[]{"api/java_net", "api/java_nio"};
        }
    };
    private Question qRemoteAgent = new TestArgsQuestion("RemoteAgent"){

        protected Question getNext() {
            return this.getNext(RuntimeInterview.this.iRuntimeRemoteAgent, RuntimeInterview.this.qURL);
        }

        String[] getTestURL() {
            return ServicesInterview.distrTests.toArray(new String[0]);
        }
    };
    private Question qURL = new TestArgsQuestion("url"){

        protected Question getNext() {
            return this.getNext(RuntimeInterview.this.iRuntimeURL, RuntimeInterview.this.qIDL);
        }

        String[] getTestURL() {
            return new String[]{"api/java_net"};
        }
    };
    private Question qIDL = new TestArgsQuestion("idl"){

        protected Question getNext() {
            return this.getNext(RuntimeInterview.this.iRuntimeIDL, RuntimeInterview.this.qPrint);
        }

        String[] getTestURL() {
            return new String[]{"api/org_omg", "api/javax_management/remote"};
        }
    };
    private Question qPrint = new TestArgsQuestion("print"){

        protected Question getNext() {
            return this.getNext(RuntimeInterview.this.iRuntimePrint, RuntimeInterview.this.qAWT);
        }

        String[] getTestURL() {
            return new String[]{"api/javax_print", "api/java_awt/interactive", "api/javax_swing/interactive"};
        }
    };
    private Question qAWT = new TestArgsQuestion("awt"){

        protected Question getNext() {
            return this.getNext(RuntimeInterview.this.iRuntimeAWT, RuntimeInterview.this.qRunJDWP);
        }

        public boolean isHidden() {
            if (RuntimeInterview.this.isHeadless()) {
                this.setValue("No");
                return true;
            }
            return super.isHidden();
        }

        String[] getTestURL() {
            return new String[]{"api/java_awt", "api/javax_swing"};
        }
    };
    private Question qRunJDWP = new TestArgsQuestion("jdwp"){

        protected Question getNext() {
            return this.getNext(RuntimeInterview.this.iJDWP, RuntimeInterview.this.qJPLIS);
        }

        String[] getTestURL() {
            return new String[]{"vm/jdwp"};
        }
    };
    private Question qJPLIS = new TestArgsQuestion("jplis"){

        protected Question getNext() {
            return this.getNext(RuntimeInterview.this.iRuntimeJPLIS, RuntimeInterview.this.qJSSE);
        }

        String[] getTestURL() {
            return new String[]{"api/java_lang/instrument/Instrumentation"};
        }
    };
    private Question qJSSE = new TestArgsQuestion("jsse"){

        protected Question getNext() {
            return this.getNext(RuntimeInterview.this.iRuntimeJSSE, RuntimeInterview.this.qStaticSigTest);
        }

        String[] getTestURL() {
            return new String[]{"api/javax_net", "api/javax_rmi/ssl"};
        }
    };
    private Question qStaticSigTest = new TestArgsQuestion("staticsigtest"){

        protected Question getNext() {
            return this.getNext(RuntimeInterview.this.iRuntimeStaticSigTest, RuntimeInterview.this.qEnd);
        }

        String[] getTestURL() {
            return new String[]{"api/signaturetest"};
        }
    };
    protected ErrorQuestion qNoFileError = new ErrorQuestion(this, "noFileError");
    protected ErrorQuestion qNoDirectoryError = new ErrorQuestion(this, "noDirectoryError");
    private int mode;
    private String precompileDir;
    private AgentInterview iAgent = new AgentInterview(this);
    private Interview iRuntimeAudio = new RuntimeAudioInterview(this);
    private RuntimeAWTInterview iRuntimeAWT = new RuntimeAWTInterview(this);
    private Interview iRuntimeFP = new RuntimeFPInterview(this);
    private Interview iRuntimeIDL = new RuntimeIDLInterview(this);
    private Interview iRuntimeJAAS = new RuntimeJAASInterview(this);
    private Interview iRuntimeJGSS = new RuntimeJGSSInterview(this);
    private Interview iRuntimePrint = new RuntimePrintInterview(this);
    private Interview iRuntimeMemory = new RuntimeMemoryInterview(this);
    private Interview iRuntimeNetwork = new RuntimeNetworkInterview(this);
    private RuntimeTcpPortRangeInterview iRuntimeTcpPortRange = new RuntimeTcpPortRangeInterview(this);
    private Interview iRuntimeRemoteAgent = new RuntimeRemoteAgentInterview(this);
    private Interview iRuntimeStaticSigTest = new RuntimeStaticSigTestInterview(this);
    private RuntimeTestExecuteInterview iRuntimeTestExecute = new RuntimeTestExecuteInterview(this);
    private Interview iRuntimeURL = new RuntimeURLInterview(this);
    private Interview iRuntimeJPLIS = new RuntimeJPLISInterview(this);
    private Interview iJDWP = new RuntimeJDWPInterview(this);
    private Interview iRuntimeJSSE = new RuntimeJSSEInterview(this);
    private ServicesInterview iServices = new ServicesInterview(this);
    private Question qEnd = new FinalQuestion(this);
    private EnvironmentInterview parent;

    RuntimeInterview(EnvironmentInterview environmentInterview) {
        super(environmentInterview, "runtime");
        this.parent = environmentInterview;
        this.setFirstQuestion(this.qIntro);
    }

    void setMode(int n) {
        this.mode = n;
    }

    int getMode() {
        return this.mode;
    }

    void setFirstQuestion() {
        Question question = this.getMode() == 3 || this.getMode() == 2 ? this.qRefCompileFile : this.qIntro;
        this.setFirstQuestion(question);
    }

    TestPlatformInterview getTestPlatformInterview() {
        return this.parent.getTestPlatformInterview();
    }

    JCKParameters getRootInterview() {
        return this.parent.getRootInterview();
    }

    RuntimeTestExecuteInterview getRuntimeTestExecuteInterview() {
        return this.iRuntimeTestExecute;
    }

    String getTestClassPath() {
        String string;
        TestSuite testSuite = this.getRootInterview().getTestSuite();
        String string2 = string = testSuite == null ? null : testSuite.getTestSuiteInfo("testclasspath");
        if (string == null) {
            TestPlatformInterview testPlatformInterview = this.getTestPlatformInterview();
            char c = testPlatformInterview.getFileSep();
            char c2 = testPlatformInterview.getPathSep();
            string = "$testSuiteRootDir" + c + "classes";
            if (this.getMode() == 3 && this.precompileDir != null && this.precompileDir.length() != 0) {
                string = this.precompileDir + c2 + "$testSuiteRootDir" + c + "classes";
            }
        }
        return string;
    }

    boolean isSimple() {
        return this.parent.isSimple();
    }

    boolean isHeadless() {
        return this.getTestPlatformInterview().isHeadless();
    }

    public void export(Map map) {
        if (this.parent.isSimple()) {
            if (this.qTCPRange.isHidden()) {
                this.qTCPRange.export(map);
            }
            this.iRuntimeNetwork.export(map);
            this.iRuntimeURL.export(map);
            this.iRuntimeAudio.export(map);
            this.iRuntimeAWT.export(map);
            this.iRuntimePrint.export(map);
            this.iRuntimeMemory.export(map);
            this.iRuntimeIDL.export(map);
            this.iRuntimeJAAS.export(map);
            this.iJDWP.export(map);
            this.iRuntimeJPLIS.export(map);
            this.iRuntimeRemoteAgent.export(map);
            this.iRuntimeTestExecute.export(map);
            this.iRuntimeJSSE.export(map);
        } else {
            this.iRuntimeTestExecute.exportForAdvancedMode(map);
            this.iRuntimeAWT.exportForAdvancedMode(map);
        }
    }

    private Question callRuntimeTestExecute() {
        return this.callInterview(this.iRuntimeTestExecute, this.qTestArgs);
    }

    AgentInterview getAgentInterview() {
        return this.iAgent;
    }

    void appendAgentCommandPrefix(StringBuffer stringBuffer) {
        this.iAgent.appendCommandPrefix(stringBuffer);
    }

    public RuntimeRemoteAgentInterview getRuntimeRemoteAgentInterview() {
        return (RuntimeRemoteAgentInterview)this.iRuntimeRemoteAgent;
    }

    ServicesInterview getServicesInterview() {
        return this.iServices;
    }

    private abstract class TestArgsQuestion
    extends SwitchInterviewQuestion {
        TestArgsQuestion(String string) {
            super(RuntimeInterview.this, string);
        }

        protected final Question getNext(Interview interview, Question question) {
            if (this.showNestedInterview()) {
                return RuntimeInterview.this.callInterview(interview, question);
            }
            if (this.value == "No") {
                return question;
            }
            return null;
        }

        JCKParameters getJCKParametersInterview() {
            return RuntimeInterview.this.getRootInterview();
        }
    }
}

