/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.lib;

import com.sun.javatest.util.StringArray;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Arguments
implements Cloneable,
Collection<String> {
    private ArrayList<String> args = new ArrayList();

    static Arguments toArguments(String[] stringArray) {
        Arguments arguments = new Arguments(stringArray);
        return arguments;
    }

    public Arguments(String[] stringArray) {
        this();
        this.append(stringArray);
    }

    public Arguments() {
    }

    public void append(String[] stringArray) {
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.args.add(stringArray[i]);
            }
        }
    }

    public void append(String string) {
        this.args.add(string);
    }

    public void remove(int n) {
        if (n >= 0 && n < this.size()) {
            this.args.remove(n);
        }
    }

    public boolean contains(String string) {
        return this.args.contains(string);
    }

    public String get(int n) {
        return this.args.get(Math.min(n, this.args.size() - 1));
    }

    public void set(int n, String string) {
        if (n > -1 && n < this.args.size()) {
            this.args.set(n, string);
        }
    }

    @Override
    public int size() {
        return this.args.size();
    }

    @Override
    public void clear() {
        this.args.clear();
    }

    public void addFileNames(File file, final String string) {
        FileFilter fileFilter = new FileFilter(){

            public boolean accept(File file) {
                return file.getName().endsWith(string) || file.isDirectory();
            }
        };
        this.findFiles(fileFilter, file);
    }

    public void removeArgs(String string, int n) {
        int n2 = this.args.indexOf(string);
        if (n2 > -1 && n > 0) {
            while (n > 0) {
                this.args.remove(n2);
                if (n2 == this.args.size() || this.args.get(n2).startsWith("-")) break;
                --n;
            }
        }
    }

    public void removeArgs(String string) {
        int n = 0;
        while (n < this.args.size()) {
            if (this.args.get(n).endsWith(string)) {
                this.args.remove(n);
                continue;
            }
            ++n;
        }
    }

    public ArrayList<String> getArgs(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.args.size(); ++i) {
            String string2 = this.args.get(i);
            if (!string2.endsWith(string)) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    public void addArg(String string) {
        if (!this.args.contains(string)) {
            this.args.add(0, string);
        }
    }

    public void addArgs(String string, String string2) {
        if (!this.args.contains(string)) {
            this.args.add(0, string2);
            this.args.add(0, string);
        }
    }

    public void setArgs(String[] stringArray) {
        this.args.clear();
        this.append(stringArray);
    }

    public String[] getArgs() {
        return this.args.toArray(new String[0]);
    }

    public String getArgsAsString(String string) {
        String string2 = null;
        if (this.args.size() > 0) {
            string2 = StringArray.join(this.getArgs(), string);
        }
        return string2;
    }

    public String[] getArg(String string, int n) {
        String[] stringArray = null;
        int n2 = this.args.indexOf(string);
        if (n2 != -1) {
            stringArray = this.args.subList(n2, Math.min(n2 + n, this.args.size())).toArray(new String[0]);
        }
        return stringArray;
    }

    public String[] getTail(String string, boolean bl) {
        String[] stringArray = new String[]{};
        int n = this.args.indexOf(string);
        if (n != -1) {
            int n2;
            if ((n += bl ? 0 : 1) < (n2 = this.args.size())) {
                stringArray = this.args.subList(n, n2).toArray(new String[0]);
            }
        }
        return stringArray;
    }

    public String getValue(String string, String string2) {
        int n;
        String string3 = string2;
        if (this.args.size() > 0 && (n = this.args.indexOf(string)) != -1 && n != this.args.size()) {
            string3 = this.args.get(n + 1);
        }
        return string3;
    }

    public String getValue(String string) {
        String string2 = this.getValue(string, null);
        return string2 != null && !string2.startsWith("-") ? string2 : null;
    }

    public void updateValue(String string, String string2) {
        int n;
        if (this.args.size() > 0 && (n = this.args.indexOf(string)) > -1 && ++n < this.args.size() && !this.args.get(n).startsWith("-")) {
            this.args.set(n, string2);
        }
    }

    public Object clone() {
        try {
            Arguments arguments = (Arguments)super.clone();
            arguments.args = (ArrayList)this.args.clone();
            return arguments;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    private void findFiles(FileFilter fileFilter, File file) {
        File[] fileArray = file.listFiles(fileFilter);
        if (fileArray == null) {
            return;
        }
        for (File file2 : fileArray) {
            if (file2.isDirectory()) {
                this.findFiles(fileFilter, file2);
                continue;
            }
            this.args.add(file2.getAbsolutePath());
        }
    }

    @Override
    public boolean add(String string) {
        return this.args.add(string);
    }

    @Override
    public boolean addAll(Collection<? extends String> collection) {
        return this.args.addAll(collection);
    }

    @Override
    public boolean contains(Object object) {
        return this.args.contains(object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.args.containsAll(collection);
    }

    @Override
    public boolean isEmpty() {
        return this.args.isEmpty();
    }

    @Override
    public Iterator<String> iterator() {
        return this.args.iterator();
    }

    @Override
    public boolean remove(Object object) {
        return this.args.remove(object);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return this.args.removeAll(collection);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return this.args.retainAll(collection);
    }

    @Override
    public Object[] toArray() {
        return this.args.toArray();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return this.args.toArray(TArray);
    }
}

