/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.lib;

import com.sun.jck.lib.multijvm.group.util.Util;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.Socket;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCovRemoteSupport {
    public static final String AGENT_PREFIX = "-javaagent:";
    public static final String OPTIONS_CLS = "com.sun.tdk.jcov.tools.Options";
    public static final String DESCR_CLS = "com.sun.tdk.jcov.tools.OptionDescr";
    public static final String AGENT_CLS = "com.sun.tdk.jcov.Agent";
    public static final String VALID_OPTS_FLD = "VALID_OPTIONS";
    public static final String PARSE_METH = "parseAgentString";
    public static final String GETVALUE_METH = "getValue";
    public static final String PORT_OPT = "port";
    public static final String EXIT_CMD = "exit";
    public static final String SAVE_CMD = "save";
    public static final String SAVED_RESP = "saved";
    public static final String AUTOSAVE_DISABLED = "autosave disabled";
    public static final String EXIT_WITHOUT_SAVE = "exitWithoutSave";
    private int port = -1;
    private static PrintStream LOG = new PrintStream(new OutputStream(){

        public void write(int n) throws IOException {
            if (Boolean.getBoolean("jck.jcovsupport.debug")) {
                System.out.write(n);
            }
        }
    });
    private boolean adjusted;

    public boolean wasCommandAdjusted() {
        return this.adjusted;
    }

    private void adjustProcessCommand(List<String> list, int n) {
        String string = list.get(n);
        String string2 = string + ",port=" + String.valueOf(this.port);
        list.set(n, string2);
    }

    public static JCovRemoteSupport getInstance(List<String> list) {
        JCovRemoteSupport jCovRemoteSupport = null;
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i);
            if (!string.startsWith(AGENT_PREFIX)) continue;
            try {
                String string2 = JCovRemoteSupport.extractPortFromString(string);
                jCovRemoteSupport = new JCovRemoteSupport();
                if (string2 != null) {
                    jCovRemoteSupport.port = Integer.parseInt(string2);
                    break;
                }
                jCovRemoteSupport.port = JCovRemoteSupport.getFreePort();
                jCovRemoteSupport.adjustProcessCommand(list, i);
                jCovRemoteSupport.adjusted = true;
            }
            catch (Exception exception) {
                exception.printStackTrace(LOG);
            }
            break;
        }
        return jCovRemoteSupport;
    }

    private static int getFreePort() {
        try {
            return Util.getFreePort();
        }
        catch (IOException iOException) {
            iOException.printStackTrace(LOG);
            throw new RuntimeException("Unexpected exception!", iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendSaveAndExitCommands(String string) {
        try {
            Socket socket = new Socket(string, this.port);
            try {
                this.sendCommand(socket, SAVE_CMD, SAVED_RESP);
                this.sendCommand(socket, EXIT_WITHOUT_SAVE, AUTOSAVE_DISABLED);
            }
            finally {
                socket.close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace(LOG);
        }
    }

    private static String extractPortFromString(String string) throws Exception {
        String string2 = string.substring(AGENT_PREFIX.length());
        int n = string2.indexOf(61);
        String string3 = string2.substring(0, n);
        String string4 = string2.substring(n + 1);
        URL uRL = new File(string3).toURI().toURL();
        URLClassLoader uRLClassLoader = new URLClassLoader(new URL[]{uRL});
        Class<?> clazz = Class.forName(AGENT_CLS, true, uRLClassLoader);
        Field field = clazz.getField(VALID_OPTS_FLD);
        Object object = field.get(null);
        Class<?> clazz2 = Class.forName(DESCR_CLS, true, uRLClassLoader);
        Class<?> clazz3 = Class.forName(OPTIONS_CLS, true, uRLClassLoader);
        Constructor<?> constructor = clazz3.getConstructor(Array.newInstance(clazz2, 0).getClass());
        Object obj = constructor.newInstance(object);
        Method method = clazz3.getMethod(PARSE_METH, String.class);
        method.invoke(obj, string4);
        Method method2 = clazz3.getMethod(GETVALUE_METH, String.class);
        return (String)method2.invoke(obj, PORT_OPT);
    }

    private void sendCommand(Socket socket, String string, String string2) throws IOException {
        LOG.println("Sending " + string + " to " + this.port + "...");
        PrintStream printStream = new PrintStream(socket.getOutputStream());
        printStream.print(string);
        printStream.flush();
        if (string2 == null) {
            LOG.println("Don't wait for response from " + this.port);
            return;
        }
        InputStream inputStream = socket.getInputStream();
        byte[] byArray = new byte[1024];
        int n = inputStream.read(byArray);
        String string3 = null;
        if (n != -1) {
            string3 = new String(byArray, 0, n);
        }
        LOG.println("Recieved '" + string3 + "' from " + string + " from " + this.port);
        if (!string2.equals(string3)) {
            LOG.println("Response '" + string3 + "' doesn't match with expected '" + string2 + "'");
        }
    }
}

