/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.lib;

import com.sun.jck.lib.Arguments;
import com.sun.jck.lib.Invoker;
import com.sun.jck.lib.SchemaGenTool;
import java.io.PrintStream;

public class SchemaGenInvoker
extends Invoker {
    protected String schemaGenClassName = null;
    protected Arguments javaFiles = new Arguments();

    public static void main(String[] stringArray) {
        int n;
        if (stringArray == null || stringArray.length == 0) {
            System.out.println("Usage:");
            System.out.println("\tjava com.sun.jck.lib.SchemaGenInvoker -jxc <className> - -d <path> <java files...>");
            System.out.println("\tOptions:");
            System.out.println("\t-jxc <className> :  specifies the class name that implements the SchemaGenTool interface");
            System.out.println("\t                    There is com.sun.jck.lib.SchemaGen that is fully compatible");
            System.out.println("\t                    with Sun's reference implementation ");
            System.out.println("\t-d <path>        :  specifies where to place processor");
            System.out.println("\t<java files..>   :  specifies the list of an java files");
            System.exit(1);
        }
        try {
            n = new SchemaGenInvoker(stringArray).execute(System.out, System.err);
        }
        catch (Invoker.ArgumentException argumentException) {
            n = -1;
        }
        catch (Invoker.InvokeException invokeException) {
            invokeException.printStackTrace(System.err);
            n = -1;
        }
        System.exit(n);
    }

    public SchemaGenInvoker(String[] stringArray) {
        super(stringArray);
    }

    public SchemaGenInvoker(Arguments arguments) {
        super(arguments);
    }

    public void processArguments() throws Invoker.ArgumentException {
        this.schemaGenClassName = this.args.getValue("-jxc");
        if (this.schemaGenClassName == null) {
            throw new Invoker.ArgumentException("No class name specified after the option '-jxc'.");
        }
        this.args.removeArgs("-jxc", 2);
        this.args.setArgs(this.args.getTail("-", false));
        super.processArguments();
        this.args.removeArgs("-d", 2);
        int n = this.args.size();
        if (n == 0) {
            throw new Invoker.ArgumentException("No java files specified.");
        }
        for (int i = 0; i < n; ++i) {
            this.javaFiles.append(this.args.get(i).split("\u0085"));
        }
        this.adjustArgs();
    }

    public int invoke(PrintStream printStream, PrintStream printStream2) throws Invoker.InvokeException {
        try {
            Class<?> clazz = Class.forName(this.schemaGenClassName);
            SchemaGenTool schemaGenTool = (SchemaGenTool)SchemaGenTool.class.cast(clazz.newInstance());
            return schemaGenTool.generate(this.javaFiles.getArgs(), this.outDir, printStream, printStream2);
        }
        catch (Exception exception) {
            exception.printStackTrace(printStream2);
            String string = exception.getMessage();
            throw new Invoker.InvokeException("Schemagen invoker failed " + (string != null ? "with the message '" + string + "'" : ""));
        }
    }

    private void adjustArgs() {
        for (int i = this.args.size() - 1; i > 1; --i) {
            String string = this.args.get(i);
            if (!string.endsWith(".java")) continue;
            int n = string.indexOf(47);
            int n2 = string.indexOf(92);
            if (n == -1 || n2 == -1) continue;
            this.args.set(i, string.replace(n2 < n ? (char)'/' : '\\', n2 < n ? (char)'\\' : '/'));
        }
    }
}

