/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.lib;

import com.sun.jck.lib.Arguments;
import com.sun.jck.lib.Invoker;
import com.sun.jck.lib.WSImportTool;
import java.io.File;
import java.io.PrintStream;

public class WSImportInvoker
extends Invoker {
    protected String className;
    protected String[] wsdls;
    protected String[] xmls;
    protected File wsdlLocation;

    public WSImportInvoker(String[] stringArray) {
        super(stringArray);
    }

    public WSImportInvoker(Arguments arguments) {
        super(arguments);
    }

    public void processArguments() throws Invoker.ArgumentException {
        String string = null;
        String string2 = null;
        super.processArguments();
        if (this.args.contains("-class")) {
            this.className = this.args.getValue("-class");
        }
        if (this.className == null) {
            throw new Invoker.ArgumentException("No class name specified after the option '-class'.");
        }
        this.args.removeArgs("-class", 2);
        if (this.args.contains("-b")) {
            string = this.args.getValue("-b");
        }
        if (string == null) {
            throw new Invoker.ArgumentException("No xml modifiers are specified after the option '-xmls'.");
        }
        this.args.removeArgs("-b", 2);
        this.xmls = string.split("\u0085");
        if (this.args.contains("-wsdl")) {
            string2 = this.args.getValue("-wsdl");
        }
        if (string2 == null) {
            throw new Invoker.ArgumentException("No wsdl specified after the option '-wsdl'.");
        }
        this.args.removeArgs("-wsdl", 2);
        this.wsdls = string2.split("\u0085");
        if (this.outDir == null) {
            throw new Invoker.ArgumentException("No '-d <path>' option supplied.");
        }
        this.wsdlLocation = this.outDir;
        this.args.removeArgs("-d", 2);
        this.args.setArgs(this.args.getTail("-", false));
    }

    public int invoke(PrintStream printStream, PrintStream printStream2) throws Invoker.InvokeException {
        try {
            Class<?> clazz = Class.forName(this.className);
            WSImportTool wSImportTool = (WSImportTool)WSImportTool.class.cast(clazz.newInstance());
            Integer n = wSImportTool.compile(this.wsdls, this.xmls, this.outDir, this.args.getArgs(), printStream, printStream2);
            if (n instanceof Integer) {
                int n2 = n;
                return n2 == 0 ? 0 : -1;
            }
            throw new Invoker.InvokeException("Unexpected return value from WSImport: " + n);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new Invoker.InvokeException("Can't load the class: " + this.className);
        }
        catch (ClassCastException classCastException) {
            throw new Invoker.InvokeException("The " + this.className + " class does not implement interface com.sun.jck.lib.WSImportTool");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new Invoker.InvokeException("The class or its nullary constructor is not accessible: " + illegalAccessException.toString());
        }
        catch (InstantiationException instantiationException) {
            throw new Invoker.InvokeException("Can't instantiate the class: " + this.className);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new Invoker.InvokeException("WSImport threw exception: " + illegalArgumentException.getMessage());
        }
    }
}

