/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.lib.multijvm.group;

import com.sun.javatest.Command;
import com.sun.javatest.Status;
import com.sun.jck.lib.multijvm.group.AgentTask;
import com.sun.jck.lib.multijvm.group.TaskManager;
import com.sun.jck.lib.multijvm.group.util.ArgMap;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.List;
import java.util.concurrent.BlockingQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecCmd
extends Command {
    @Override
    public Status run(String[] stringArray, PrintWriter printWriter, PrintWriter printWriter2) {
        try {
            ArgMap argMap = new ArgMap(stringArray, (Enum[])new Key[]{Key.TASK, Key.TEST});
            List<String> list = argMap.getUnmapped();
            List<String> list2 = argMap.get(Key.TASK);
            List<String> list3 = argMap.get(Key.TEST);
            TaskManager taskManager = this.getManager(list);
            return this.run(taskManager, list2, list3, printWriter, printWriter2);
        }
        catch (Throwable throwable) {
            if (throwable instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throwable.printStackTrace(printWriter2);
            return Status.error("Unexpected: " + throwable);
        }
    }

    protected Status run(TaskManager taskManager, List<String> list, List<String> list2, PrintWriter printWriter, PrintWriter printWriter2) throws Throwable {
        AgentTask agentTask;
        BlockingQueue<AgentTask> blockingQueue = taskManager.getAgentQueue(list);
        do {
            if ((agentTask = (AgentTask)blockingQueue.poll()) == null) {
                agentTask = this.createAgent(taskManager, list);
                agentTask.start(printWriter, printWriter2);
                if (agentTask.waitForConnection(taskManager.getTimeout() * 2L)) continue;
                throw new IOException("Starting agent timeout. (firewall doesn't allow connection to localhost from the same host?)");
            }
            agentTask.cancelClose();
        } while (agentTask.isClosed() || !agentTask.checkReady());
        try {
            Status status = agentTask.runTest(list2, printWriter, printWriter2);
            if (agentTask.needClose(status)) {
                agentTask.close();
                return status;
            }
            try {
                if (!agentTask.waitForConnection(taskManager.getTimeout())) {
                    throw new IOException("Agent connection timeout");
                }
                agentTask.scheduleClose();
                blockingQueue.put(agentTask);
            }
            catch (Throwable throwable) {
                agentTask.close();
                printWriter2.println("Error getting connection due to: ");
                throwable.printStackTrace(printWriter2);
            }
            return status;
        }
        catch (Throwable throwable) {
            agentTask.close();
            throw throwable;
        }
    }

    protected AgentTask createAgent(TaskManager taskManager, List<String> list) {
        return new AgentTask(taskManager, list);
    }

    protected TaskManager getManager(List<String> list) throws Throwable {
        return TaskManager.getManager(list);
    }

    public static void main(String[] stringArray) {
        ExecCmd execCmd = new ExecCmd();
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(System.out));
        PrintWriter printWriter2 = new PrintWriter(new OutputStreamWriter(System.err));
        Status status = ((Command)execCmd).run(stringArray, printWriter, printWriter2);
        printWriter.flush();
        printWriter2.flush();
        status.exit();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Key {
        TASK,
        TEST,
        AGENT,
        ENV,
        CMD,
        TESTSOURCE;

    }
}

