/*
 * Copyright (c) 1997-2017 Oracle and/or its affiliates. All rights reserved.
 */

package	javasoft.sqe.tests.api.javax.activation.FileDataSource;

import	java.io.*;
import	javax.activation.*;
import	com.sun.javatest.*;
import com.sun.javatest.lib.MultiTest; 
import	javasoft.sqe.tests.api.javax.activation.TestClasses.TestFileTypeMap;

/**
 * Create an instance of type FileDataSource, if successfull
 * then this testcase passes, otherwise it fails. <p>
 */

public class FileDataSource_Test extends MultiTest
{
private static final String	kFileName = "FDSTestFile.txt";

public static void main(String argv[])
{
	FileDataSource_Test lTest = new FileDataSource_Test();
	Status lStatus = lTest.run(argv, new PrintWriter(System.err, true), new PrintWriter(System.out, true));
	lStatus.exit();
}

public void init()
{

}

public Status FileDataSourceTest1()
{
	FileDataSource fdsFromFile = new FileDataSource(new File(kFileName));		// API TEST
	FileDataSource fdsFromFileName = new FileDataSource(kFileName);		// API TEST
	if (!kFileName.equals(fdsFromFileName.getName()))
		return Status.failed("FileDataSource(fileName) nameTest failed");
	if (!kFileName.equals(fdsFromFile.getName()))
		return Status.failed("FileDataSource(File) nameTest failed");

	return Status.passed("FileDataSource() test passed");
}

public Status FileDataSourceTest2()
{
	InputStream is = null;
	FileDataSource lSource = new FileDataSource("MissingFile");	// API TEST

	try {
		is = lSource.getInputStream();
		is.close();
	} catch (FileNotFoundException fnfex) {
		return Status.passed("FileDataSource() no input test passed");
	} catch (Exception ex) {
		return Status.failed("FileDataSource() no input test failed: unexpected exception " + ex.toString());
	}

	return Status.failed("FileDataSource() no input test failed: getInputStream() didn't throw");
}

public Status FileDataSourceTest3() throws IOException
{
	File lFile = new File("bad/name");

	// lets make sure this worked:
	try {
	    OutputStream os = new FileOutputStream(lFile);
	    os.close();
	    return Status.failed("no output test testing failure: unable to prevent output");
	} catch(IOException ioex) {
	}

	OutputStream os = null;
	FileDataSource fds = new FileDataSource(lFile); 	// API TEST

	try {
		os = fds.getOutputStream();
	} catch (IOException ioex) {
		return Status.passed("FileDataSource() no output test passed");
	} catch (Exception ex) {
		return Status.failed("FileDataSource() no output test failed:  unexpected exception " + ex.toString());
	}
	os.close();

	return Status.failed("FileDataSource() no output test failed: getOutputStream didn't throw");
}

}
