/*
 * Copyright (c) 1997-2017 Oracle and/or its affiliates. All rights reserved.
 */

package	javasoft.sqe.tests.api.javax.activation.MailcapCommandMap;

import	java.beans.*;
import	java.io.*;
import	javax.activation.*;
import	com.sun.javatest.*;
import	java.awt.datatransfer.*;
import com.sun.javatest.lib.MultiTest; 
import	javasoft.sqe.tests.api.javax.activation.TestClasses.TestDCH;

/**
 * Create a MailcapCommandMap instance, use it to call createDataContentHandler()
 * method with mimetype parameter, if it successfully returns non-null object
 * of type DataContentHandler, then this test passes otherwise it fails. <p>
 */

public class createDataContentHandler_Test extends MultiTest
{
private static String testMailcap[] = { 
	"text/*;;		x-java-view=rom.pun.activation.viewers.FooViewer",
	"text/*;;		x-java-content-handler=javasoft.sqe.tests.api.javax.activation.TestClasses.TestDCH",
	"text/*;;		x-java-view=rom.pun.activation.viewers.MooViewer"  // make sure the last one takes precedence
};

private MailcapCommandMap commandMap = null;
private String message;

public static void main(String argv[])
{
	createDataContentHandler_Test lTest = new createDataContentHandler_Test();
	Status lStatus = lTest.run(argv, new PrintWriter(System.err, true), new PrintWriter(System.out, true));
	lStatus.exit();
}

private boolean runTest(String mimeType, String verb, String className, String dchClassName)
{
        DataContentHandler dch = commandMap.createDataContentHandler(mimeType);         // API TEST

        if (dchClassName == null) {
                if (dch != null) {
                        message = "createDataContentHandler returned unexpected object for " + mimeType;
                        return false;
                }
        } else {
                if (!dchClassName.equals(dch.getClass().getName())) {
                        message = "createDataContentHandler returned " + dch.getClass().getName() + " for " + mimeType;
                        return false;
                }
        }
        return true;
}

public Status createDataContentHandlerTest()
{
	message = "createDataContentHandler() test succeeded";

	// test using default mailcap file. We have no idea what could be defined there
	// in any implementation. Test a made up type that is unlikely to appear in any
	// default mapping for the appropriate behavior
	commandMap = new MailcapCommandMap();

	// test a mimeType that's not mapped at all	
	if (!runTest("foo/plain", null, null, null))
		return Status.failed(message);

	// use addMailcap to define a mapping, and one to bind a DataContentHandler
	// the named viewer class need not exist, but the dch class must exist.  Use one we already have:
	// in the default sun mailcap, this also tests overriding an existing mapping. There's no general
	// way to do that, since there's no way to know what types are provided as keys.

	commandMap.addMailcap("text/*;;x-java-view=javasoft.sqe.tests.api.javax.activation.TestViewer");
	commandMap.addMailcap(
		"text/*;;x-java-content-handler=javasoft.sqe.tests.api.javax.activation.TestClasses.TestDCH");
	if (!runTest("text/plain", "view", 
					"javasoft.sqe.tests.api.javax.activation.TestViewer", 
					"javasoft.sqe.tests.api.javax.activation.TestClasses.TestDCH"))
		return Status.failed(message);

	// now we can test overriding the previous:	
	commandMap.addMailcap("text/*;;x-java-view=javasoft.sqe.tests.api.javax.activation.FooViewer");
	if (!runTest("text/plain", "view", 
					"javasoft.sqe.tests.api.javax.activation.FooViewer", 
					"javasoft.sqe.tests.api.javax.activation.TestClasses.TestDCH"))
		return Status.failed(message);

	// see how it handles it if I add some garbage.  There's no exception defined, so at best, 
	// it will be ignored, and the results will remain as they were before.

	commandMap.addMailcap("x6`&@:;;fudge&_12345");
	if (!runTest("text/plain", "view", 
					"javasoft.sqe.tests.api.javax.activation.FooViewer", 
					"javasoft.sqe.tests.api.javax.activation.TestClasses.TestDCH"))
		return Status.failed(message);

    	return Status.passed(message);
}

}
