/*
 * Copyright (c) 1997-2017 Oracle and/or its affiliates. All rights reserved.
 */

package	javasoft.sqe.tests.api.javax.activation.MimeTypeParameterList;

import	java.beans.*;
import	java.io.*;
import	javax.activation.*;
import	java.net.*;
import	com.sun.javatest.*;
import com.sun.javatest.lib.MultiTest; 
import	java.awt.datatransfer.*;
import	javasoft.sqe.tests.api.javax.activation.TestClasses.*;

/**
 * Create an instance of MimeTypeParameterList, then use it to call isEmpty() method,
 * if it returns a boolean value for this list, then this testcase passes, otherwise
 * it fails. <p>
 */

public class isEmpty_Test extends MultiTest
{
public static void main(String argv[])
{
	isEmpty_Test lTest = new isEmpty_Test();
	Status lStatus = lTest.run(argv, new PrintWriter(System.err, true), new PrintWriter(System.out, true));
	lStatus.exit();
}

public Status isEmptyTest()
{
        try {
              MimeTypeParameterList mtpl1 =  new MimeTypeParameterList(";charset=us-ascii;isoset=iso-9000;foo=abc");

              if( mtpl1 == null )
                  return Status.failed("Failed: to create MimeTypeParameterList object.");

	      if( mtpl1.isEmpty() )	// API TEST
		  return Status.failed("isEmpty() returned unexpected false value.");

	      MimeTypeParameterList mtpl2 = new MimeTypeParameterList();

	      if( mtpl2 == null )
                  return Status.failed("Failed: to create MimeTypeParameterList object.");

              if( !mtpl2.isEmpty() )	// API TEST
                  return Status.failed("isEmpty() returned unexpected true value.");

        } catch(Exception ex) {
                return Status.failed("isEmpty() threw " + ex.toString());
        }

	return Status.passed("isEmpty() test succeeded");
}

}
