/*
 * Copyright (c) 1997-2017 Oracle and/or its affiliates. All rights reserved.
 */

package	javasoft.sqe.tests.api.javax.activation.MimeTypeParameterList;

import	java.beans.*;
import	java.io.*;
import	javax.activation.*;
import	java.net.*;
import	com.sun.javatest.*;
import com.sun.javatest.lib.MultiTest; 
import	java.awt.datatransfer.*;
import	javasoft.sqe.tests.api.javax.activation.TestClasses.*;

/**
 * Create an instance of MimeTypeParameterList, then use it to call size() method,
 * if it returns the number of name-value pairs in this list, then this testcase
 * passes, otherwise it fails. <p>
 */

public class size_Test extends MultiTest
{
public static void main(String argv[])
{
	size_Test lTest = new size_Test();
	Status lStatus = lTest.run(argv, new PrintWriter(System.err, true), new PrintWriter(System.out, true));
	lStatus.exit();
}

public Status sizeTest()
{
        try {
              MimeTypeParameterList mtpl =  new MimeTypeParameterList(";charset=us-ascii;isoset=iso-9000;foo=abc");

              if( mtpl == null )
                  return Status.failed("Failed: to create MimeTypeParameterList object using constructor");
	      int value = mtpl.size();	// API TEST

	      if( value == 0 )
		  return Status.failed("size() returned unexpected zero value.");

	      MimeTypeParameterList mtpol = new MimeTypeParameterList();

              value = mtpol.size();       // API TEST

              if( value != 0 )
                  return Status.failed("size() returned unexpected non-zero value.");

        } catch(Exception ex) {
                return Status.failed("size() threw " + ex.toString());
        }

	return Status.passed("size() test succeeded");
}

}
