/*
 * Copyright (c) 1997-2017 Oracle and/or its affiliates. All rights reserved.
 */

package	javasoft.sqe.tests.api.javax.activation.TestClasses;

import javax.activation.*;
import java.io.*;

/**
 * A TestDataSource for the DataHandler tests. It will return a 
 * the passed in byte stream via the getinputstream method.
 */

public class TestDataSource implements DataSource {

    byte byte_array[] = null;
    
    public TestDataSource(byte byte_array[]){
	this.byte_array = byte_array;
    }

    public InputStream getInputStream() throws IOException {
	ByteArrayInputStream bis = new ByteArrayInputStream(byte_array);
	return bis;
	
    }
    public OutputStream getOutputStream() throws IOException {
	return null;
    }
    public String getContentType(){
	return "application/octet-stream";
    }
    public String getName() {
	    return "name";
    }
}
