/*
 * Copyright (c) 2002-2015 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests.javax.mail.Folder;

import java.util.*;
import java.io.*;
import javax.mail.*;
import javax.mail.internet.*;
import com.sun.javatest.*;
import javasoft.sqe.tests.javax.mail.util.MailTest;

/**
 * This class tests the <strong>isSubscribed()</strong> API.
 * It does this by invoking the api under test and then checking
 * the value of the returned object.	<p>
 *
 *		Returns true if this Folder is subscribed <p>
 * api2test: public boolean isSubscribed()  <p>
 *
 * how2test: Call this API on a folder object. If it returns a boolean <p>
 *	     value then the testcase passes. This method can be invoked <p>
 *	     on a closed Folder. The default implementation returns true.
 */

public class isSubscribed_Test extends MailTest {

    public static void main( String argv[] )
    {
        isSubscribed_Test test = new isSubscribed_Test();
        Status s = test.run(argv, System.err, System.out);
	s.exit();
    }

    public Status run(String argv[], PrintWriter log, PrintWriter out)
    {
	super.run(argv, log, out);
	parseArgs(argv);	// parse command-line options

        out.println("\nTesting class Folder: isSubscribed()\n");

        try {
          // Connect to host server
             Store store = connect2host(protocol, host, user, password);

          // Get a Folder object
	     Folder root = getRootFolder(store);
             Folder folder = root.getFolder(mailbox);

             if (folder == null ) {
	         return Status.failed("Invalid folder object!");
       	     }
	  // BEGIN UNIT TEST 1:
	     // test with closed folder
	     
	     boolean subscribed;
             out.println("UNIT TEST 1: isSubscribed();");

             subscribed = folder.isSubscribed();	// API TEST

             if( subscribed ) {
		 out.println("This folder is subscribed.");
                 out.println("UNIT TEST 1: passed\n");
             }
	  // END UNIT TEST 1:
          // BEGIN UNIT TEST 2:
	     // test with open folder

	     folder.open(Folder.READ_ONLY);
             out.println("UNIT TEST 2: isSubscribed();");

             subscribed = folder.isSubscribed();       // API TEST

             if( subscribed ) {
                 out.println("This folder is subscribed.");
                 out.println("UNIT TEST 2: passed\n");
             }
          // END UNIT TEST 2:
	     folder.close(false);
	     store.close();
	     checkStatus();

        } catch ( Exception e ) {
	     handlException(e);
        }
	return status;
     }
}
