/*
 * Copyright (c) 2002-2015 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests.javax.mail.Message;

import java.util.*;
import java.io.*;
import javax.mail.*;
import javax.mail.internet.*;
import com.sun.javatest.*;
import javasoft.sqe.tests.javax.mail.util.MailTest;

/**
 * This class tests the <strong>getReceivedDate()</strong> API.
 * It does this by passing various valid input values and then checking
 * the type of the returned object.	<p>
 *
 *		Get the date this message was received. <p>
 * api2test: public Date getReceivedDate()  <p>
 *
 * how2test: Call this API and verify that it returns a Date object. If this is 
 *	     true then this testcase passes, otherwise it fails.
 */

public class getReceivedDate_Test extends MailTest {

    public static void main( String argv[] )
    {
        getReceivedDate_Test test = new getReceivedDate_Test();
        Status s = test.run(argv, System.err, System.out);
	s.exit();
    }

    public Status run(String argv[], PrintWriter log, PrintWriter out)
    {
	super.run(argv, log, out);
	parseArgs(argv);	// parse command-line options

        out.println("\nTesting class Message: getReceivedDate()\n");

        try {
          // Connect to host server
             Store store = connect2host(protocol, host, user, password);

          // Get a Folder object
	     Folder root = getRootFolder(store);
             Folder folder = root.getFolder(mailbox);

             if( folder == null ) {
                 return Status.failed("Invalid folder object!");
             }
             folder.open(Folder.READ_ONLY);

	     if( msgcount == -1 ) {
                 msgcount = folder.getMessageCount();
                 if( msgcount < 1 )
                     return Status.failed("Mail folder is empty!");
             }
	     Date  dateRec;

             for( int i = 1; i <= msgcount; i++ )
             {
             // Get the message
                MimeMessage msg = (MimeMessage)folder.getMessage(i);

	        if( msg == null ) {
		    log.println("WARNING: FAILED TO GET MESSAGE NUMBER: "+ i);
		    continue;
	        }
	     // BEGIN UNIT TEST:
		// Get date this message was received
	        out.println("UNIT TEST "+ i +":  getReceivedDate()");

	        dateRec = msg.getReceivedDate();	// API TEST

	        if( dateRec != null ) {
		    out.println("Message received on "+ dateRec);
                    out.println("UNIT TEST "+ i +":  passed\n");
	        } else {
		        out.println("UNIT TEST "+ i +":  FAILED\n");
		        errors++;
	        }
	     // END UNIT TEST:
	     }
	     folder.close(false);
	     store.close();
	     checkStatus();

        } catch ( Exception e ) {
	     handlException(e);
        }
	return status;
     }
}
