/*
 * Copyright (c) 2002-2015 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests.javax.mail.exception;

import java.io.*;
import javax.mail.*;
import com.sun.javatest.*;
import javasoft.sqe.tests.javax.mail.util.MailTest;

/**
 * This class tests the <strong>FolderNotFoundException()</strong> API.
 * It does this by passing various valid input values and then checking
 * the type of the returned object.	<p>
 *
 * api2test: public FolderNotFoundException(String, Folder | void) <p>
 *
 * how2test: Try to open non-existing folder and if this results in
 *	     an FolderNotFound exception, then this testcase passes.
 */

public class folderNotFoundExp_Test extends MailTest {

    public static void main( String argv[] )
    {
        folderNotFoundExp_Test test = new folderNotFoundExp_Test();
        Status s = test.run(argv, System.err, System.out);
	s.exit();
    }

    public Status run(String argv[], PrintWriter log, PrintWriter out)
    {
	super.run(argv, log, out);
	parseArgs(argv);	// parse command-line options
	mailbox="xyzfolder";

        out.println("\nTesting class FolderNotFoundException: FolderNotFoundException()\n");

        try {
           // Connect to host server
              Store store = connect2host(protocol, host, user, password);

           // Get a Folder object
              Folder folder = store.getFolder(mailbox);

              if( folder == null ) {
                  return Status.failed("Invalid folder object!");
              }
           // BEGIN UNIT TEST 1:
	      out.println("UNIT TEST 1: FolderNotFoundException(String, Folder)");
	      folder.open(Folder.READ_ONLY);	    // API TEST
           // END UNIT TEST 1:

	      status = Status.failed(" Failed to catch FolderNotFoundException ");
        } catch ( FolderNotFoundException e ) {
		out.println("UNIT TEST 1: passed.\n");
		ExceptionTest(e);
	} catch ( MessagingException me ) {
                handlException(me);
        }
	return status;
     }
}
