/*
 * Copyright (c) 2002-2015 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests.javax.mail.internet.ContentType;

import java.util.*;
import java.io.*;
import javax.mail.*;
import javax.mail.internet.*;
import com.sun.javatest.*;
import javasoft.sqe.tests.javax.mail.util.MailTest;

/**
 * This class tests the <strong>toString()</strong> API.
 * It does by passing various valid input values and then checking
 * the type of the returned object.	<p>
 * 
 *		Retrieve a RFC2045 style string representation of Content-Type. <p>
 * api2test: public String toString()  <p>
 *
 * how2test: Call API, verify that it returns a string object.
 *	     If so then testcase passes, otherwise it fails.
 */

public class toString_Test extends MailTest {

    public static void main( String argv[] )
    {
        toString_Test test = new toString_Test();
        Status s = test.run(argv, System.err, System.out);
	s.exit();
    }

    public Status run(String argv[], PrintWriter log, PrintWriter out)
    {
	 super.run(argv, log, out);
	// parse command-line options
	parseArgs(argv);

        out.println("\nTesting class ContentType: ContentType(void|String|ParameterList)\n");

        try {
	   // create a ContentType object
              ContentType ct = new ContentType(pattern);

              if( ct == null )
		  return Status.failed("Failed to create ContentType object!");

           // BEGIN UNIT TEST 1:
              out.println("UNIT TEST 1:  toString()");
              String rfc2045 = ct.toString();    // API TEST

              if( rfc2045 != null )
                  out.println("UNIT TEST 1: passed");
              else {
                   out.println("UNIT TEST 1: FAILED");
                   errors++;
              }
           // END UNIT TEST 1:

              checkStatus();
        } catch ( Exception e ) {
	      handlException(e);
        }
	return status;
     }
}
